/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.transport.ucp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.marre.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UcpMsg {
    protected static final byte STX = 2;
    protected static final byte ETX = 3;
    private static Logger log_ = LoggerFactory.getLogger((Class)(class$org$marre$sms$transport$ucp$UcpMsg == null ? (class$org$marre$sms$transport$ucp$UcpMsg = UcpMsg.class$("org.marre.sms.transport.ucp.UcpMsg")) : class$org$marre$sms$transport$ucp$UcpMsg));
    protected String[] ucpFields_;
    protected char or_;
    protected int trn_;
    protected byte ot_;
    static /* synthetic */ Class class$org$marre$sms$transport$ucp$UcpMsg;

    public UcpMsg(int nFields) {
        this.ucpFields_ = new String[nFields];
    }

    public void setField(int field, String value) {
        this.ucpFields_[field] = value;
    }

    public String getField(int field) {
        return this.ucpFields_[field];
    }

    protected void setOR(char or) {
        this.or_ = or;
    }

    protected void setOT(byte ot) {
        this.ot_ = ot;
    }

    public void setTRN(int trn) {
        this.trn_ = trn;
    }

    public byte calcChecksum(String data) {
        int checksum = 0;
        for (int i = 0; i < data.length(); ++i) {
            checksum = (checksum + data.charAt(i)) % 256;
        }
        return (byte)(checksum & 0xFF);
    }

    public String buildCommand() {
        int i;
        StringBuffer command = new StringBuffer(200);
        int length = 0;
        length = 13;
        for (i = 0; i < this.ucpFields_.length; ++i) {
            if (this.ucpFields_[i] != null) {
                length += this.ucpFields_[i].length();
            }
            ++length;
        }
        command.append(StringUtil.intToString(this.trn_, 2));
        command.append('/');
        command.append(StringUtil.intToString(length += 3, 5));
        command.append('/');
        command.append(this.or_);
        command.append('/');
        command.append(StringUtil.intToString(this.ot_, 2));
        command.append('/');
        for (i = 0; i < this.ucpFields_.length; ++i) {
            if (this.ucpFields_[i] != null) {
                command.append(this.ucpFields_[i]);
            }
            command.append('/');
        }
        command.append(StringUtil.byteToHexString(this.calcChecksum(command.toString())));
        return command.toString();
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(2);
        os.write(this.buildCommand().getBytes());
        os.write(3);
    }

    public byte[] getCommand() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200);
        try {
            this.writeTo(baos);
        }
        catch (IOException ex) {
            log_.debug("getCommand() - Failed to write to an ByteArrayOutputStream!");
        }
        return baos.toByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

