/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.transport.pswincom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.Socket;
import java.util.Properties;
import org.marre.sms.SmsAddress;
import org.marre.sms.SmsException;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsPdu;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsTextMessage;
import org.marre.sms.SmsUserData;
import org.marre.sms.transport.SmsTransport;
import org.marre.sms.transport.pswincom.PsWinXmlResponseParser;
import org.marre.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PsWinXmlTransport
implements SmsTransport {
    private static Logger log_ = LoggerFactory.getLogger((Class)(class$org$marre$sms$transport$pswincom$PsWinXmlTransport == null ? (class$org$marre$sms$transport$pswincom$PsWinXmlTransport = PsWinXmlTransport.class$("org.marre.sms.transport.pswincom.PsWinXmlTransport")) : class$org$marre$sms$transport$pswincom$PsWinXmlTransport));
    private String username_;
    private String password_;
    private String server_;
    private int port_;
    static /* synthetic */ Class class$org$marre$sms$transport$pswincom$PsWinXmlTransport;

    public void init(Properties props) throws SmsException {
        this.username_ = props.getProperty("smsj.pswincom.username");
        this.password_ = props.getProperty("smsj.pswincom.password");
        this.server_ = props.getProperty("smsj.pswincom.server", "sms.pswin.com");
        this.port_ = Integer.parseInt(props.getProperty("smsj.pswincom.port", "1111"));
        log_.debug("init() : username = " + this.username_);
        log_.debug("init() : password = " + this.password_);
        log_.debug("init() : server = " + this.server_);
        log_.debug("init() : port = " + this.port_);
        if (this.username_ == null || this.password_ == null) {
            throw new SmsException("Incomplete login information for pswincom");
        }
    }

    private void addMsg(StringWriter xmlStringWriter, SmsPdu smsPdu, SmsAddress dest, SmsAddress sender) throws SmsException {
        SmsUserData userData = smsPdu.getUserData();
        xmlStringWriter.write("<MSG>\r\n");
        xmlStringWriter.write("<RCPREQ>Y</RCPREQ>\r\n");
        switch (smsPdu.getDcs().getAlphabet()) {
            case 2: {
                xmlStringWriter.write("<OP>9</OP>\r\n");
                xmlStringWriter.write("<TEXT>");
                xmlStringWriter.write(StringUtil.bytesToHexString(userData.getData()));
                xmlStringWriter.write("</TEXT>\r\n");
                break;
            }
            case 0: {
                xmlStringWriter.write("<TEXT>");
                xmlStringWriter.write(SmsPduUtil.readSeptets(userData.getData(), userData.getLength()));
                xmlStringWriter.write("</TEXT>\r\n");
                break;
            }
            case 1: {
                xmlStringWriter.write("<OP>8</OP>\r\n");
                xmlStringWriter.write("<TEXT>");
                xmlStringWriter.write(StringUtil.bytesToHexString(smsPdu.getUserDataHeaders()) + StringUtil.bytesToHexString(userData.getData()));
                xmlStringWriter.write("</TEXT>\r\n");
                break;
            }
            default: {
                throw new SmsException("Unsupported alphabet");
            }
        }
        xmlStringWriter.write("<RCV>");
        xmlStringWriter.write(dest.getAddress());
        xmlStringWriter.write("</RCV>\r\n");
        if (sender != null) {
            xmlStringWriter.write("<SND>");
            xmlStringWriter.write(sender.getAddress());
            xmlStringWriter.write("</SND>\r\n");
        }
        if (smsPdu.getDcs().getMessageClass() == 0) {
            xmlStringWriter.write("<CLASS>");
            xmlStringWriter.write("0");
            xmlStringWriter.write("</CLASS>\r\n");
        }
        xmlStringWriter.write("</MSG>\r\n");
    }

    private void addTextMsg(StringWriter xmlStringWriter, SmsTextMessage msg, SmsAddress dest, SmsAddress sender) throws SmsException {
        SmsUserData userData = msg.getUserData();
        xmlStringWriter.write("<MSG>\r\n");
        switch (userData.getDcs().getAlphabet()) {
            case 2: {
                xmlStringWriter.write("<OP>9</OP>\r\n");
                xmlStringWriter.write("<TEXT>");
                xmlStringWriter.write(StringUtil.bytesToHexString(userData.getData()));
                xmlStringWriter.write("</TEXT>\r\n");
                break;
            }
            case 0: {
                xmlStringWriter.write("<TEXT>");
                xmlStringWriter.write(msg.getText());
                xmlStringWriter.write("</TEXT>\r\n");
                break;
            }
            default: {
                throw new SmsException("Unsupported alphabet");
            }
        }
        xmlStringWriter.write("<RCV>");
        xmlStringWriter.write(dest.getAddress());
        xmlStringWriter.write("</RCV>\r\n");
        if (sender != null) {
            xmlStringWriter.write("<SND>");
            xmlStringWriter.write(sender.getAddress());
            xmlStringWriter.write("</SND>\r\n");
        }
        if (userData.getDcs().getMessageClass() == 0) {
            xmlStringWriter.write("<CLASS>");
            xmlStringWriter.write("0");
            xmlStringWriter.write("</CLASS>\r\n");
        }
        xmlStringWriter.write("</MSG>\r\n");
    }

    private void writeXmlTo(OutputStream os, SmsMessage msg, SmsAddress dest, SmsAddress sender) throws IOException, SmsException {
        StringWriter xmlWriter = new StringWriter(1024);
        xmlWriter.write("<?xml version=\"1.0\"?>\r\n");
        xmlWriter.write("<SESSION>\r\n");
        xmlWriter.write("<CLIENT>" + this.username_ + "</CLIENT>\r\n");
        xmlWriter.write("<PW>" + this.password_ + "</PW>\r\n");
        xmlWriter.write("<MSGLST>\r\n");
        if (msg instanceof SmsTextMessage) {
            this.addTextMsg(xmlWriter, (SmsTextMessage)msg, dest, sender);
        } else {
            SmsPdu[] msgPdu = msg.getPdus();
            for (int i = 0; i < msgPdu.length; ++i) {
                this.addMsg(xmlWriter, msgPdu[i], dest, sender);
            }
        }
        xmlWriter.write("</MSGLST>\r\n");
        xmlWriter.write("</SESSION>\r\n");
        String xmlDoc = xmlWriter.toString();
        os.write(xmlDoc.getBytes());
    }

    private void sendReqToPsWinCom(byte[] xmlReq) throws IOException, SmsException {
        Socket xmlSocket = new Socket(this.server_, this.port_);
        OutputStream os = xmlSocket.getOutputStream();
        os.write(xmlReq);
        InputStream is = xmlSocket.getInputStream();
        PsWinXmlResponseParser responseParser = new PsWinXmlResponseParser(is);
        responseParser.parse();
        if (!responseParser.getLogon().equals("OK")) {
            throw new SmsException("Failed to send message: " + responseParser.getReason());
        }
    }

    public String send(SmsMessage msg, SmsAddress dest, SmsAddress sender) throws SmsException, IOException {
        byte[] xmlReq;
        if (dest.getTypeOfNumber() == 5) {
            throw new SmsException("Cannot sent SMS to ALPHANUMERIC address");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            this.writeXmlTo(baos, msg, dest, sender);
            baos.close();
            xmlReq = baos.toByteArray();
        }
        catch (IOException ex) {
            throw new SmsException("Failed to build xml request", ex);
        }
        this.sendReqToPsWinCom(xmlReq);
        return null;
    }

    public void connect() {
    }

    public void disconnect() {
    }

    public void ping() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

