/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.transport.pswincom;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.marre.sms.SmsException;
import org.marre.sms.transport.pswincom.PsWinXmlCleanupReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PsWinXmlResponseParser {
    protected InputStream xmlInputStream_;
    protected Document respDoc_;

    public PsWinXmlResponseParser(InputStream xmlInputStream) {
        this.xmlInputStream_ = xmlInputStream;
    }

    public void parse() throws IOException, SmsException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            InputStreamReader isReader = new InputStreamReader(this.xmlInputStream_);
            PsWinXmlCleanupReader filterReader = new PsWinXmlCleanupReader(isReader);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.respDoc_ = builder.parse(new InputSource(filterReader));
        }
        catch (ParserConfigurationException ex) {
            throw new SmsException("Something wrong with xml", ex);
        }
        catch (SAXException ex) {
            throw new SmsException("Failed to parse xml response", ex);
        }
    }

    public String getLogon() {
        NodeList listOfLogons = this.respDoc_.getElementsByTagName("LOGON");
        Node logon = listOfLogons.item(0);
        return this.getText(logon);
    }

    public String getReason() {
        NodeList listOfReasons = this.respDoc_.getElementsByTagName("REASON");
        Node reason = listOfReasons.item(0);
        return this.getText(reason);
    }

    protected String getText(Node node) {
        StringBuffer strBuff = new StringBuffer();
        if (node.hasChildNodes()) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 3) continue;
                Text childText = (Text)child;
                String text = childText.getData();
                strBuff.append(text);
            }
        }
        return strBuff.length() > 0 ? strBuff.toString() : null;
    }
}

