/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.transport.gsm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import org.marre.sms.transport.gsm.GsmComm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialComm
implements GsmComm {
    private static Logger log_ = LoggerFactory.getLogger((Class)(class$org$marre$sms$transport$gsm$SerialComm == null ? (class$org$marre$sms$transport$gsm$SerialComm = SerialComm.class$("org.marre.sms.transport.gsm.SerialComm")) : class$org$marre$sms$transport$gsm$SerialComm));
    private static final int DEFAULT_BIT_RATE = 19200;
    private SerialPort serialPort_;
    private OutputStream serialOs_;
    private InputStream serialIs_;
    private String appName_;
    private String portName_;
    private int bitRate_;
    private int dataBits_;
    private int stopBits_;
    private int parity_;
    private int flowControl_;
    private boolean echo_;
    static /* synthetic */ Class class$org$marre$sms$transport$gsm$SerialComm;

    public SerialComm(String appName, String portName) {
        this.appName_ = appName;
        this.portName_ = portName;
        this.bitRate_ = 19200;
        this.dataBits_ = 8;
        this.stopBits_ = 1;
        this.parity_ = 0;
        this.flowControl_ = 0;
        this.echo_ = true;
    }

    private SerialPort openSerialPort(String portName) throws PortInUseException {
        Object serialPort = null;
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1 || !portId.getName().equals(portName)) continue;
            return (SerialPort)portId.open(this.appName_, 3000);
        }
        return null;
    }

    public void open() throws IOException {
        try {
            this.serialPort_ = this.openSerialPort(this.portName_);
        }
        catch (PortInUseException piuEx) {
            throw (IOException)new IOException(piuEx.getMessage()).initCause(piuEx);
        }
        if (this.serialPort_ == null) {
            throw new IOException("Failed to open port : " + this.portName_);
        }
        try {
            this.serialOs_ = this.serialPort_.getOutputStream();
            this.serialIs_ = this.serialPort_.getInputStream();
            this.serialPort_.setSerialPortParams(this.bitRate_, this.dataBits_, this.stopBits_, this.parity_);
            this.serialPort_.setFlowControlMode(this.flowControl_);
        }
        catch (UnsupportedCommOperationException e) {
            this.serialPort_.close();
            this.serialPort_ = null;
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public void close() {
        if (this.serialOs_ != null) {
            try {
                this.serialOs_.close();
            }
            catch (Exception ex) {
                log_.error("serialOs_.close failed", (Throwable)ex);
            }
        }
        if (this.serialIs_ != null) {
            try {
                this.serialIs_.close();
            }
            catch (Exception ex) {
                log_.error("serialIs_.close failed", (Throwable)ex);
            }
        }
        if (this.serialPort_ != null) {
            try {
                this.serialPort_.close();
            }
            catch (Exception ex) {
                log_.error("serialPort_.close failed", (Throwable)ex);
            }
        }
        this.serialOs_ = null;
        this.serialIs_ = null;
        this.serialPort_ = null;
    }

    public void send(String row) throws IOException {
        log_.info(">> " + row);
        this.serialOs_.write(row.getBytes());
        if (this.echo_) {
            String string = this.readOneRowOfData(null);
        }
    }

    public String readLine() throws IOException {
        return this.readLine(null);
    }

    public String readLine(String find) throws IOException {
        return this.readOneRowOfData(find);
    }

    private String readOneRowOfData(String find) throws IOException {
        int ch;
        StringBuffer buffer = new StringBuffer(256);
        while ((ch = this.serialIs_.read()) != -1 && ch != 10) {
            if (ch == 13) continue;
            buffer.append((char)ch);
            if (find == null || !find.equals(buffer.toString())) continue;
        }
        String row = buffer.toString();
        log_.info("<< " + row);
        return row;
    }

    public void setBitRate(String theBitRate) {
        this.bitRate_ = "110".equals(theBitRate) ? 110 : ("134".equals(theBitRate) ? 134 : ("150".equals(theBitRate) ? 150 : ("300".equals(theBitRate) ? 300 : ("600".equals(theBitRate) ? 600 : ("1200".equals(theBitRate) ? 1200 : ("2400".equals(theBitRate) ? 2400 : ("4800".equals(theBitRate) ? 4800 : ("9600".equals(theBitRate) ? 9600 : ("14400".equals(theBitRate) ? 14400 : ("19200".equals(theBitRate) ? 19200 : ("38400".equals(theBitRate) ? 38400 : ("57600".equals(theBitRate) ? 57600 : ("115200".equals(theBitRate) ? 115200 : ("128000".equals(theBitRate) ? 128000 : 19200))))))))))))));
    }

    public void setDataBits(String theDataBits) {
        this.dataBits_ = "5".equals(theDataBits) ? 5 : ("6".equals(theDataBits) ? 6 : ("7".equals(theDataBits) ? 7 : ("8".equals(theDataBits) ? 8 : 8)));
    }

    public void setFlowControl(String theFlowControl) {
        this.flowControl_ = "RTSCTS".equals(theFlowControl) ? 3 : ("XONXOFF".equals(theFlowControl) ? 12 : ("NONE".equals(theFlowControl) ? 0 : 0));
    }

    public void setParity(String theParity) {
        this.parity_ = "NONE".equals(theParity) ? 0 : ("EVEN".equals(theParity) ? 2 : ("ODD".equals(theParity) ? 1 : ("MARK".equals(theParity) ? 3 : ("SPACE".equals(theParity) ? 4 : 0))));
    }

    public void setStopBits(String theStopBits) {
        this.stopBits_ = "1".equals(theStopBits) ? 1 : ("1.5".equals(theStopBits) ? 3 : ("2".equals(theStopBits) ? 2 : 1));
    }

    public void setEcho(boolean echo) {
        this.echo_ = echo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

