/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.siemens;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Random;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsPdu;
import org.marre.util.StringUtil;

public class SiemensOtaMessage
implements SmsMessage {
    protected int myVersion = 1;
    protected String myName = "";
    protected String myType = "";
    protected long myReferenceId;
    protected int myDataSize;
    protected int myNumberOfPackets;
    protected byte[] myContent;

    public SiemensOtaMessage(String name, String type, byte[] content) {
        this.myName = name;
        this.myType = type;
        this.myContent = content;
        this.init();
    }

    public SiemensOtaMessage(int version, String name, String type, byte[] content) {
        this.myVersion = version;
        this.myName = name;
        this.myType = type;
        this.myContent = content;
        this.init();
    }

    private void init() {
        this.myReferenceId = new Random().nextLong();
        this.myDataSize = 118 - this.myName.length() - this.myType.length();
        this.myNumberOfPackets = (int)Math.ceil((float)this.myContent.length / (float)this.myDataSize);
    }

    private byte[] getHeader(int actPacketNumber) {
        byte[] header = new byte[22 + this.myName.length() + this.myType.length()];
        header[0] = 47;
        header[1] = 47;
        header[2] = 83;
        header[3] = 69;
        header[4] = 79;
        header[5] = (byte)(this.myVersion & 0xFF);
        header[6] = (byte)(this.myDataSize & 0xFF);
        header[7] = (byte)(this.myDataSize >> 8 & 0xFF);
        header[8] = (byte)(this.myReferenceId & 0xFFL);
        header[9] = (byte)(this.myReferenceId >> 8 & 0xFFL);
        header[10] = (byte)(this.myReferenceId >> 16 & 0xFFL);
        header[11] = (byte)(this.myReferenceId >> 24 & 0xFFL);
        header[12] = (byte)(actPacketNumber & 0xFF);
        header[13] = (byte)(actPacketNumber >> 8 & 0xFF);
        header[14] = (byte)(this.myNumberOfPackets & 0xFF);
        header[15] = (byte)(this.myNumberOfPackets >> 8 & 0xFF);
        header[16] = (byte)(this.myContent.length & 0xFF);
        header[17] = (byte)(this.myContent.length >> 8 & 0xFF);
        header[18] = (byte)(this.myContent.length >> 16 & 0xFF);
        header[19] = (byte)(this.myContent.length >> 24 & 0xFF);
        header[20] = (byte)(this.myType.length() & 0xFF);
        header[21] = (byte)(this.myType.charAt(0) & 0xFF);
        header[22] = (byte)(this.myType.charAt(1) & 0xFF);
        header[23] = (byte)(this.myType.charAt(2) & 0xFF);
        header[24] = (byte)(this.myName.length() & 0xFF);
        for (int i = 0; i < this.myName.length(); ++i) {
            header[25 + i] = (byte)(this.myName.charAt(i) & 0xFF);
        }
        return header;
    }

    public SmsPdu[] getPdus() {
        SmsPdu[] smsPdus = new SmsPdu[this.myNumberOfPackets];
        SmsDcs dcs = SmsDcs.getGeneralDataCodingDcs(1, (byte)1);
        for (int i = 0; i < this.myNumberOfPackets; ++i) {
            SmsPdu smsPdu;
            byte[] pdu = new byte[140];
            byte[] header = this.getHeader(i + 1);
            System.arraycopy(header, 0, pdu, 0, header.length);
            int offset = this.myDataSize * i;
            if (i == this.myNumberOfPackets - 1) {
                this.myDataSize = this.myContent.length % this.myDataSize;
            }
            System.arraycopy(this.myContent, offset, pdu, header.length, this.myDataSize);
            smsPdus[i] = smsPdu = new SmsPdu(null, pdu, pdu.length, dcs);
        }
        return smsPdus;
    }

    public static byte[] loadFromFile(File file) throws IOException {
        int n;
        int len = (int)file.length();
        FileInputStream fin = new FileInputStream(file);
        byte[] content = new byte[len];
        for (int nread = 0; nread < len; nread += n) {
            n = fin.read(content, nread, len - nread);
            if (n != -1) continue;
            throw new IOException("Error loading Compound from file");
        }
        return content;
    }

    public static void main(String[] args) {
        String name = "Operator.bmp";
        String type = "bmp";
        byte[] data = null;
        try {
            data = SiemensOtaMessage.loadFromFile(new File(args[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SiemensOtaMessage message = new SiemensOtaMessage(22518750, name, type, data);
        SmsPdu[] pdus = message.getPdus();
        System.out.println("Data   : " + StringUtil.bytesToHexString(data));
        for (int i = 0; i < pdus.length; ++i) {
            System.out.println("UD     : " + StringUtil.bytesToHexString(pdus[i].getUserData().getData()));
        }
    }
}

