/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.nokia;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsPortAddressedMessage;
import org.marre.sms.SmsUserData;
import org.marre.sms.nokia.OtaBitmap;

public class NokiaOperatorLogo
extends SmsPortAddressedMessage {
    protected boolean myDiscardNokiaHeaders;
    protected byte[] myBitmap;
    protected int myMcc;
    protected int myMnc;

    public NokiaOperatorLogo(OtaBitmap theOtaBitmap, int theMcc, int theMnc) {
        this(theOtaBitmap.getBytes(), theMcc, theMnc);
    }

    public NokiaOperatorLogo(byte[] theOtaImage, int theMcc, int theMnc) {
        super(5506, 0);
        this.myBitmap = theOtaImage;
        this.myMcc = theMcc;
        this.myMnc = theMnc;
    }

    public NokiaOperatorLogo(byte[] theOtaImage, int theMcc, int theMnc, boolean discardHeaders) {
        super(5506, 0);
        this.myDiscardNokiaHeaders = discardHeaders;
        this.myBitmap = theOtaImage;
        this.myMcc = theMcc;
        this.myMnc = theMnc;
    }

    public NokiaOperatorLogo(OtaBitmap theBitmap, int[] theOperatorMccMnc) {
        this(theBitmap, theOperatorMccMnc[0], theOperatorMccMnc[1]);
    }

    public NokiaOperatorLogo(byte[] theOtaImage, int[] theOperatorMccMnc) {
        this(theOtaImage, theOperatorMccMnc[0], theOperatorMccMnc[1]);
    }

    public SmsUserData getUserData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(140);
        try {
            if (!this.myDiscardNokiaHeaders) {
                baos.write(48);
            }
            SmsPduUtil.writeBcdNumber(baos, "" + this.myMcc);
            if (this.myMnc < 10) {
                SmsPduUtil.writeBcdNumber(baos, "0" + this.myMnc);
            } else {
                SmsPduUtil.writeBcdNumber(baos, "" + this.myMnc);
            }
            if (!this.myDiscardNokiaHeaders) {
                baos.write(10);
            }
            baos.write(this.myBitmap);
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new SmsUserData(baos.toByteArray());
    }
}

