/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.nokia;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.marre.sms.SmsPortAddressedMessage;
import org.marre.sms.SmsUserData;
import org.marre.sms.nokia.NokiaPart;

abstract class NokiaMultipartMessage
extends SmsPortAddressedMessage {
    private List myParts = new LinkedList();

    protected NokiaMultipartMessage() {
        super(5514, 0);
    }

    protected void addMultipart(byte theItemType, byte[] data) {
        this.myParts.add(new NokiaPart(theItemType, data));
    }

    protected void clear() {
        this.myParts.clear();
    }

    public SmsUserData getUserData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(140);
        try {
            baos.write(48);
            for (int i = 0; i < this.myParts.size(); ++i) {
                NokiaPart part = (NokiaPart)this.myParts.get(i);
                byte[] data = part.getData();
                baos.write(part.getItemType());
                baos.write((byte)(data.length >> 8 & 0xFF));
                baos.write((byte)(data.length & 0xFF));
                baos.write(data);
            }
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new SmsUserData(baos.toByteArray());
    }
}

