/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUserData;

public final class SmsUdhUtil {
    private SmsUdhUtil() {
    }

    public static int getTotalSize(SmsUdhElement[] theUdhElements) {
        int totLength = 0;
        if (theUdhElements == null) {
            return 0;
        }
        for (int i = 0; i < theUdhElements.length; ++i) {
            totLength += theUdhElements[i].getTotalSize();
        }
        return totLength;
    }

    public static byte[] toByteArray(SmsUdhElement[] theUdhElements) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
        if (theUdhElements == null) {
            return new byte[0];
        }
        baos.write((byte)SmsUdhUtil.getTotalSize(theUdhElements));
        try {
            for (int i = 0; i < theUdhElements.length; ++i) {
                theUdhElements[i].writeTo(baos);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return baos.toByteArray();
    }

    public static boolean isConcat(SmsUserData ud, byte[] udh) {
        int maxChars;
        int udLength = ud.getLength();
        int bytesLeft = 140;
        if (udh != null) {
            bytesLeft -= udh.length;
        }
        switch (ud.getDcs().getAlphabet()) {
            case 0: {
                maxChars = bytesLeft * 8 / 7;
                break;
            }
            case 2: {
                maxChars = bytesLeft / 2;
                break;
            }
            default: {
                maxChars = bytesLeft;
            }
        }
        return udLength > maxChars;
    }

    public static SmsUdhElement get8BitConcatUdh(int theRefNr, int theTotSms, int theSeqNr) {
        byte[] udh = new byte[]{(byte)(theRefNr & 0xFF), (byte)(theTotSms & 0xFF), (byte)(theSeqNr & 0xFF)};
        return new SmsUdhElement(0, udh);
    }

    public static SmsUdhElement getMessageWaitingUdh(boolean storeMsg, int theMsgType, int theMsgCount) {
        byte[] udh = new byte[2];
        udh[0] = (byte)(theMsgType & 0x7F);
        if (storeMsg) {
            udh[0] = (byte)(udh[0] | 0xFFFFFF80);
        }
        udh[1] = (byte)(theMsgCount & 0xFF);
        return new SmsUdhElement(1, udh);
    }

    public static SmsUdhElement get8BitApplicationPortUdh(int theDestPort, int theOrigPort) {
        byte[] udh = new byte[]{(byte)(theDestPort & 0xFF), (byte)(theOrigPort & 0xFF)};
        return new SmsUdhElement(4, udh);
    }

    public static SmsUdhElement get16BitApplicationPortUdh(int theDestPort, int theOrigPort) {
        byte[] udh = new byte[]{(byte)(theDestPort >> 8 & 0xFF), (byte)(theDestPort & 0xFF), (byte)(theOrigPort >> 8 & 0xFF), (byte)(theOrigPort & 0xFF)};
        return new SmsUdhElement(5, udh);
    }

    public static SmsUdhElement get16BitConcatUdh(int theRefNr, int theTotSms, int theSeqNr) {
        byte[] udh = new byte[]{(byte)(theRefNr >> 8 & 0xFF), (byte)(theRefNr & 0xFF), (byte)(theTotSms & 0xFF), (byte)(theSeqNr & 0xFF)};
        return new SmsUdhElement(8, udh);
    }

    public static SmsUdhElement getEmsTextFormattingUdh(int theStartPos, int theFormatLen, byte theAlignment, byte theFontSize, byte theStyle, byte theForegroundColor, byte theBackgroundColor) {
        byte[] udh = new byte[]{(byte)(theStartPos & 0xFF), (byte)(theFormatLen & 0xFF), (byte)((theAlignment & 3 | theFontSize & 0xC | theStyle & 0xF0) & 0xFF), (byte)((theForegroundColor & 0xF | (theBackgroundColor & 0xF) << 4 & 0xF0) & 0xFF)};
        return new SmsUdhElement(10, udh);
    }

    public static SmsUdhElement getEmsUserDefinedSoundUdh(byte[] theIMelody, int position) {
        int iMelodyLength = theIMelody.length;
        byte[] udh = new byte[iMelodyLength + 1];
        udh[0] = (byte)position;
        System.arraycopy(theIMelody, 0, udh, 1, iMelodyLength);
        return new SmsUdhElement(12, udh);
    }

    public static SmsUdhElement getEmsUserPromptIndicatorUdh(int numFragments) {
        byte[] udh = new byte[]{(byte)numFragments};
        return new SmsUdhElement(19, udh);
    }

    public static SmsUdhElement getEmsVariablePictureUdh(byte[] bitmap, int width, int height, int position) {
        int otaBitmapLength = bitmap.length;
        byte[] udh = new byte[otaBitmapLength + 3];
        udh[0] = (byte)position;
        udh[1] = (byte)(width / 8);
        udh[2] = (byte)height;
        System.arraycopy(bitmap, 0, udh, 3, otaBitmapLength);
        return new SmsUdhElement(18, udh);
    }
}

