/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.io.UnsupportedEncodingException;
import org.marre.sms.SmsConcatMessage;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUserData;

public class SmsTextMessage
extends SmsConcatMessage {
    private String text_;
    private SmsDcs dcs_;

    public SmsTextMessage(String theMsg, SmsDcs theDcs) {
        this.setText(theMsg, theDcs);
    }

    public SmsTextMessage(String theMsg, int theAlphabet, byte theMessageClass) {
        this(theMsg, SmsDcs.getGeneralDataCodingDcs(theAlphabet, theMessageClass));
    }

    public SmsTextMessage(String theMsg) {
        this(theMsg, 0, 4);
    }

    public String getText() {
        return this.text_;
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null, use an empty string instead.");
        }
        this.text_ = text;
    }

    public void setText(String text, SmsDcs dcs) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null, use an empty string instead.");
        }
        if (dcs == null) {
            throw new IllegalArgumentException("dcs cannot be null.");
        }
        this.text_ = text;
        this.dcs_ = dcs;
    }

    public SmsDcs getDcs() {
        return this.dcs_;
    }

    public SmsUserData getUserData() {
        SmsUserData ud;
        try {
            switch (this.dcs_.getAlphabet()) {
                case 0: {
                    ud = new SmsUserData(SmsPduUtil.getSeptets(this.text_), this.text_.length(), this.dcs_);
                    break;
                }
                case 1: {
                    ud = new SmsUserData(this.text_.getBytes("ISO-8859-1"), this.text_.length(), this.dcs_);
                    break;
                }
                case 2: {
                    ud = new SmsUserData(this.text_.getBytes("UTF-16BE"), this.text_.length() * 2, this.dcs_);
                    break;
                }
                default: {
                    ud = null;
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return ud;
    }

    public SmsUdhElement[] getUdhElements() {
        return null;
    }
}

