/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SmsPduUtil {
    public static final char EXT_TABLE_PREFIX = '\u001b';
    public static final char[] GSM_DEFAULT_ALPHABET_TABLE = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00c7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', '\u00a0', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};
    public static final char[] GSM_DEFAULT_ALPHABET_ALTERNATIVES = new char[]{'\u00c7', '\t', '\u0391', 'A', '\u0392', 'B', '\u0397', 'H', '\u0399', 'I', '\u039a', 'K', '\u039c', 'M', '\u039d', 'N', '\u039f', 'O', '\u03a1', 'P', '\u03a4', 'T', '\u03a5', 'U', '\u03a7', 'X', '\u0396', 'Z'};

    private SmsPduUtil() {
    }

    public static byte[] getSeptets(String theMsg) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(140);
        try {
            SmsPduUtil.writeSeptets(baos, theMsg);
            baos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return baos.toByteArray();
    }

    public static void writeSeptets(OutputStream theOs, String theMsg) throws IOException {
        int data = 0;
        int nBits = 0;
        for (int i = 0; i < theMsg.length(); ++i) {
            byte gsmChar = SmsPduUtil.toGsmCharset(theMsg.charAt(i));
            data |= gsmChar << nBits;
            nBits += 7;
            while (nBits >= 8) {
                theOs.write((char)(data & 0xFF));
                data >>>= 8;
                nBits -= 8;
            }
        }
        if (nBits > 0) {
            theOs.write(data);
        }
    }

    public static String readSeptets(byte[] theArray, int theLength) {
        if (theArray == null) {
            return null;
        }
        try {
            return SmsPduUtil.readSeptets(new ByteArrayInputStream(theArray), theLength);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static String readSeptets(InputStream theIs, int theLength) throws IOException {
        StringBuffer msg = new StringBuffer(160);
        int rest = 0;
        int restBits = 0;
        while (msg.length() < theLength) {
            int data = theIs.read();
            if (data == -1) {
                throw new IOException("Unexpected end of stream");
            }
            rest |= data << restBits;
            restBits += 8;
            while (msg.length() < theLength && restBits >= 7) {
                msg.append(SmsPduUtil.fromGsmCharset((byte)(rest & 0x7F)));
                rest >>>= 7;
                restBits -= 7;
            }
        }
        return msg.toString();
    }

    public static void writeBcdNumber(OutputStream theOs, String theNumber) throws IOException {
        int bcd = 0;
        int n = 0;
        for (int i = 0; i < theNumber.length(); ++i) {
            switch (theNumber.charAt(i)) {
                case '0': {
                    bcd |= 0;
                    break;
                }
                case '1': {
                    bcd |= 0x10;
                    break;
                }
                case '2': {
                    bcd |= 0x20;
                    break;
                }
                case '3': {
                    bcd |= 0x30;
                    break;
                }
                case '4': {
                    bcd |= 0x40;
                    break;
                }
                case '5': {
                    bcd |= 0x50;
                    break;
                }
                case '6': {
                    bcd |= 0x60;
                    break;
                }
                case '7': {
                    bcd |= 0x70;
                    break;
                }
                case '8': {
                    bcd |= 0x80;
                    break;
                }
                case '9': {
                    bcd |= 0x90;
                    break;
                }
                case '*': {
                    bcd |= 0xA0;
                    break;
                }
                case '#': {
                    bcd |= 0xB0;
                    break;
                }
                case 'a': {
                    bcd |= 0xC0;
                    break;
                }
                case 'b': {
                    bcd |= 0xE0;
                }
            }
            if (++n == 2) {
                theOs.write(bcd);
                n = 0;
                bcd = 0;
                continue;
            }
            bcd >>= 4;
        }
        if (n == 1) {
            theOs.write(bcd |= 0xF0);
        }
    }

    public static String readBcdNumber(InputStream theIs, int theLength) throws IOException {
        byte[] arr = new byte[theLength];
        theIs.read(arr, 0, theLength);
        return SmsPduUtil.readBcdNumber(arr, 0, theLength);
    }

    public static String readBcdNumber(byte[] arr, int offset, int theLength) {
        StringBuffer out = new StringBuffer();
        for (int i = offset; i < offset + theLength; ++i) {
            int arrb = arr[i];
            if ((arr[i] & 0xF) <= 9) {
                out.append("" + (arr[i] & 0xF));
            }
            if ((arr[i] & 0xF) == 10) {
                out.append("*");
            }
            if ((arr[i] & 0xF) == 11) {
                out.append("#");
            }
            if (((arrb >>>= 4) & 0xF) <= 9) {
                out.append("" + (arrb & 0xF));
            }
            if ((arrb & 0xF) == 10) {
                out.append("*");
            }
            if ((arrb & 0xF) != 11) continue;
            out.append("#");
        }
        return out.toString();
    }

    public static char fromGsmCharset(byte gsmChar) {
        return GSM_DEFAULT_ALPHABET_TABLE[gsmChar];
    }

    public static byte[] toGsmCharset(String str) {
        byte[] gsmBytes = new byte[str.length()];
        for (int i = 0; i < gsmBytes.length; ++i) {
            gsmBytes[i] = SmsPduUtil.toGsmCharset(str.charAt(i));
        }
        return gsmBytes;
    }

    public static byte toGsmCharset(char theUnicodeCh) {
        int i;
        for (i = 0; i < GSM_DEFAULT_ALPHABET_TABLE.length; ++i) {
            if (GSM_DEFAULT_ALPHABET_TABLE[i] != theUnicodeCh) continue;
            return (byte)i;
        }
        for (i = 0; i < GSM_DEFAULT_ALPHABET_ALTERNATIVES.length / 2; i += 2) {
            if (GSM_DEFAULT_ALPHABET_ALTERNATIVES[i * 2] != theUnicodeCh) continue;
            return (byte)(GSM_DEFAULT_ALPHABET_ALTERNATIVES[i * 2 + 1] & 0x7F);
        }
        return 63;
    }

    public static void arrayCopy(byte[] theSrc, int theSrcStart, byte[] theDest, int theDestStart, int theLength) {
        for (int i = 0; i < theLength; ++i) {
            theDest[i + theDestStart] = theSrc[i + theSrcStart];
        }
    }

    public static void arrayCopy(byte[] theSrc, int theSrcStart, byte[] theDest, int theDestStart, int theDestBitOffset, int theBitLength) {
        int c = 0;
        int nBytes = theBitLength / 8;
        int nRestBits = theBitLength % 8;
        for (int i = 0; i < nBytes; ++i) {
            int n = theDestStart + i;
            theDest[n] = (byte)(theDest[n] | (byte)((c |= (theSrc[theSrcStart + i] & 0xFF) << theDestBitOffset) & 0xFF));
            c >>>= 8;
        }
        if (nRestBits > 0) {
            c |= (theSrc[theSrcStart + nBytes] & 255 >> 8 - nRestBits) << theDestBitOffset;
        }
        if (nRestBits + theDestBitOffset > 0) {
            int n = theDestStart + nBytes;
            theDest[n] = (byte)(theDest[n] | c & 0xFF);
        }
    }
}

