/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.util.Random;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsPdu;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUdhUtil;
import org.marre.sms.SmsUserData;

public abstract class SmsConcatMessage
implements SmsMessage {
    private static Random myRnd = new Random();

    protected SmsConcatMessage() {
    }

    public abstract SmsUserData getUserData();

    public abstract SmsUdhElement[] getUdhElements();

    private SmsPdu[] createOctalPdus(SmsUdhElement[] theUdhElements, SmsUserData theUd, int theMaxBytes) {
        SmsPdu[] smsPdus = null;
        int nMaxConcatChars = theMaxBytes - 6;
        int nMaxChars = theMaxBytes;
        if (theUd.getLength() <= nMaxChars) {
            smsPdus = new SmsPdu[]{new SmsPdu(theUdhElements, theUd)};
        } else {
            int refno = myRnd.nextInt(256);
            int nSms = theUd.getLength() / nMaxConcatChars;
            if (theUd.getLength() % nMaxConcatChars > 0) {
                ++nSms;
            }
            smsPdus = new SmsPdu[nSms];
            SmsUdhElement[] pduUdhElements = null;
            if (theUdhElements == null) {
                pduUdhElements = new SmsUdhElement[1];
            } else {
                pduUdhElements = new SmsUdhElement[theUdhElements.length + 1];
                for (int j = 0; j < theUdhElements.length; ++j) {
                    pduUdhElements[j + 1] = theUdhElements[j];
                }
            }
            for (int i = 0; i < nSms; ++i) {
                pduUdhElements[0] = SmsUdhUtil.get8BitConcatUdh(refno, nSms, i + 1);
                int udOffset = nMaxConcatChars * i;
                int udBytes = theUd.getLength() - udOffset;
                if (udBytes > nMaxConcatChars) {
                    udBytes = nMaxConcatChars;
                }
                int udLength = udBytes;
                byte[] pduUd = new byte[udBytes];
                SmsPduUtil.arrayCopy(theUd.getData(), udOffset, pduUd, 0, udBytes);
                smsPdus[i] = new SmsPdu(pduUdhElements, pduUd, udLength, theUd.getDcs());
            }
        }
        return smsPdus;
    }

    private SmsPdu[] createUnicodePdus(SmsUdhElement[] theUdhElements, SmsUserData theUd, int theMaxBytes) {
        SmsPdu[] smsPdus = null;
        int nMaxConcatChars = (theMaxBytes - 6) / 2;
        int nMaxChars = theMaxBytes / 2;
        if (theUd.getLength() <= nMaxChars) {
            smsPdus = new SmsPdu[]{new SmsPdu(theUdhElements, theUd)};
        } else {
            int refno = myRnd.nextInt(256);
            int nSms = theUd.getLength() / 2 / nMaxConcatChars;
            if (theUd.getLength() / 2 % nMaxConcatChars > 0) {
                ++nSms;
            }
            smsPdus = new SmsPdu[nSms];
            SmsUdhElement[] pduUdhElements = null;
            if (theUdhElements == null) {
                pduUdhElements = new SmsUdhElement[1];
            } else {
                pduUdhElements = new SmsUdhElement[theUdhElements.length + 1];
                for (int j = 0; j < theUdhElements.length; ++j) {
                    pduUdhElements[j + 1] = theUdhElements[j];
                }
            }
            for (int i = 0; i < nSms; ++i) {
                pduUdhElements[0] = SmsUdhUtil.get8BitConcatUdh(refno, nSms, i + 1);
                int udOffset = nMaxConcatChars * i;
                int udLength = theUd.getLength() / 2 - udOffset;
                if (udLength > nMaxConcatChars) {
                    udLength = nMaxConcatChars;
                }
                int udBytes = udLength * 2;
                byte[] pduUd = new byte[udBytes];
                SmsPduUtil.arrayCopy(theUd.getData(), udOffset * 2, pduUd, 0, udBytes);
                smsPdus[i] = new SmsPdu(pduUdhElements, pduUd, udBytes, theUd.getDcs());
            }
        }
        return smsPdus;
    }

    private SmsPdu[] createSeptetPdus(SmsUdhElement[] theUdhElements, SmsUserData theUd, int theMaxBytes) {
        SmsPdu[] smsPdus = null;
        int nMaxConcatChars = (theMaxBytes - 6) * 8 / 7;
        int nMaxChars = theMaxBytes * 8 / 7;
        if (theUd.getLength() <= nMaxChars) {
            smsPdus = new SmsPdu[]{new SmsPdu(theUdhElements, theUd)};
        } else {
            int refno = myRnd.nextInt(256);
            int nSms = theUd.getLength() / nMaxConcatChars;
            if (theUd.getLength() % nMaxConcatChars > 0) {
                ++nSms;
            }
            smsPdus = new SmsPdu[nSms];
            SmsUdhElement[] pduUdhElements = null;
            if (theUdhElements == null) {
                pduUdhElements = new SmsUdhElement[1];
            } else {
                pduUdhElements = new SmsUdhElement[theUdhElements.length + 1];
                for (int j = 0; j < theUdhElements.length; ++j) {
                    pduUdhElements[j + 1] = theUdhElements[j];
                }
            }
            String msg = SmsPduUtil.readSeptets(theUd.getData(), theUd.getLength());
            for (int i = 0; i < nSms; ++i) {
                pduUdhElements[0] = SmsUdhUtil.get8BitConcatUdh(refno, nSms, i + 1);
                int udOffset = nMaxConcatChars * i;
                int udLength = theUd.getLength() - udOffset;
                if (udLength > nMaxConcatChars) {
                    udLength = nMaxConcatChars;
                }
                byte[] pduUd = SmsPduUtil.getSeptets(msg.substring(udOffset, udOffset + udLength));
                smsPdus[i] = new SmsPdu(pduUdhElements, pduUd, udLength, theUd.getDcs());
            }
        }
        return smsPdus;
    }

    public SmsPdu[] getPdus() {
        SmsPdu[] smsPdus;
        SmsUserData ud = this.getUserData();
        SmsUdhElement[] udhElements = this.getUdhElements();
        int udhLength = SmsUdhUtil.getTotalSize(udhElements);
        int nBytesLeft = 140 - udhLength;
        switch (ud.getDcs().getAlphabet()) {
            case 0: {
                smsPdus = this.createSeptetPdus(udhElements, ud, nBytesLeft);
                break;
            }
            case 2: {
                smsPdus = this.createUnicodePdus(udhElements, ud, nBytesLeft);
                break;
            }
            default: {
                smsPdus = this.createOctalPdus(udhElements, ud, nBytesLeft);
            }
        }
        return smsPdus;
    }
}

