/*
 * Decompiled with CFR 0.152.
 */
package org.marre.mms.transport.mm1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import org.marre.mime.MimeBodyPart;
import org.marre.mms.MmsException;
import org.marre.mms.MmsHeaders;
import org.marre.mms.transport.MmsTransport;
import org.marre.mms.transport.mm1.Mm1Encoder;
import org.marre.util.IOUtil;
import org.marre.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mm1Transport
implements MmsTransport {
    private static Logger log_ = LoggerFactory.getLogger((Class)(class$org$marre$mms$transport$mm1$Mm1Transport == null ? (class$org$marre$mms$transport$mm1$Mm1Transport = Mm1Transport.class$("org.marre.mms.transport.mm1.Mm1Transport")) : class$org$marre$mms$transport$mm1$Mm1Transport));
    public static final String CONTENT_TYPE_WAP_MMS_MESSAGE = "application/vnd.wap.mms-message";
    private String myMmsProxyGatewayAddress;
    static /* synthetic */ Class class$org$marre$mms$transport$mm1$Mm1Transport;

    public void init(Properties theProps) throws MmsException {
        this.myMmsProxyGatewayAddress = theProps.getProperty("smsj.mm1.proxygateway");
        if (this.myMmsProxyGatewayAddress == null) {
            throw new MmsException("smsj.mm1.proxygateway not set");
        }
    }

    public void connect() {
    }

    public void send(MimeBodyPart theMessage, MmsHeaders theHeaders) throws MmsException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Mm1Encoder.writeMessageToStream(baos, theMessage, theHeaders);
        baos.close();
        if (log_.isDebugEnabled()) {
            String str = StringUtil.bytesToHexString(baos.toByteArray());
            log_.debug("request [" + str + "]");
        }
        URL url = new URL(this.myMmsProxyGatewayAddress);
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.addRequestProperty("Content-Length", "" + baos.size());
        urlConn.addRequestProperty("Content-Type", CONTENT_TYPE_WAP_MMS_MESSAGE);
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setAllowUserInteraction(false);
        OutputStream out = urlConn.getOutputStream();
        baos.writeTo(out);
        out.flush();
        out.close();
        baos.reset();
        baos = new ByteArrayOutputStream();
        InputStream response = urlConn.getInputStream();
        int responsecode = urlConn.getResponseCode();
        log_.debug("HTTP response code : " + responsecode);
        IOUtil.copy(response, baos);
        baos.close();
        if (log_.isDebugEnabled()) {
            String str = StringUtil.bytesToHexString(baos.toByteArray());
            log_.debug("response [" + str + "]");
        }
    }

    public void disconnect() throws IOException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

