/*
 * Decompiled with CFR 0.152.
 */
package org.marre.mms.transport.mm1;

import java.io.IOException;
import java.io.OutputStream;
import org.marre.mime.MimeBodyPart;
import org.marre.mime.MimeMultipart;
import org.marre.mime.encoder.MimeEncoder;
import org.marre.mms.MmsException;
import org.marre.mms.MmsHeaders;
import org.marre.wap.WapMimeEncoder;
import org.marre.wap.WspUtil;
import org.marre.wap.mms.MmsHeaderEncoder;

public final class Mm1Encoder {
    private static MimeEncoder myWapMimeEncoder = new WapMimeEncoder();
    private static byte myWspEncodingVersion = (byte)18;

    private Mm1Encoder() {
    }

    public static void writeMessageToStream(OutputStream out, MimeBodyPart theMessage, MmsHeaders theHeaders) throws MmsException {
        try {
            Mm1Encoder.writeHeadersToStream(out, theHeaders);
            if (theMessage instanceof MimeMultipart) {
                String ct = theMessage.getContentType().getValue();
                String newCt = WspUtil.convertMultipartContentType(ct);
                theMessage.getContentType().setValue(newCt);
            }
            MmsHeaderEncoder.writeHeaderContentType(myWspEncodingVersion, out, theMessage.getContentType());
            myWapMimeEncoder.writeBody(out, theMessage);
        }
        catch (IOException ex) {
            throw new MmsException(ex.getMessage());
        }
    }

    private static void writeHeadersToStream(OutputStream out, MmsHeaders theHeaders) throws IOException {
        MmsHeaderEncoder.writeHeaderXMmsMessageType(out, theHeaders.getMessageType());
        MmsHeaderEncoder.writeHeaderXMmsTransactionId(out, theHeaders.getTransactionId());
        MmsHeaderEncoder.writeHeaderXMmsMmsVersion(out, theHeaders.getVersion());
        if (theHeaders.getTo() != null) {
            MmsHeaderEncoder.writeHeaderTo(out, theHeaders.getTo());
        }
        if (theHeaders.getFrom() != null) {
            MmsHeaderEncoder.writeHeaderFrom(out, theHeaders.getFrom());
        }
        if (theHeaders.getSubject() != null) {
            MmsHeaderEncoder.writeHeaderSubject(out, theHeaders.getSubject());
        }
    }
}

