/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.DataSerializerHook;
import com.hazelcast.nio.serialization.FactoryIdHelper;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.Backup;
import com.hazelcast.spi.impl.BackupResponse;
import com.hazelcast.spi.impl.BinaryOperationFactory;
import com.hazelcast.spi.impl.EventServiceImpl;
import com.hazelcast.spi.impl.NormalResponse;
import com.hazelcast.spi.impl.PartitionIteratingOperation;
import com.hazelcast.spi.impl.SerializableCollection;

public final class SpiDataSerializerHook
implements DataSerializerHook {
    static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.spi", -1);
    static final int NORMAL_RESPONSE = 0;
    static final int BACKUP = 1;
    static final int BACKUP_RESPONSE = 2;
    static final int PARTITION_ITERATOR = 3;
    static final int PARTITION_RESPONSE = 4;
    static final int PARALLEL_OPERATION_FACTORY = 5;
    static final int EVENT_PACKET = 6;
    static final int COLLECTION = 7;

    @Override
    public DataSerializableFactory createFactory() {
        return new DataSerializableFactory(){

            @Override
            public IdentifiedDataSerializable create(int typeId) {
                switch (typeId) {
                    case 0: {
                        return new NormalResponse();
                    }
                    case 1: {
                        return new Backup();
                    }
                    case 2: {
                        return new BackupResponse();
                    }
                    case 3: {
                        return new PartitionIteratingOperation();
                    }
                    case 4: {
                        return new PartitionIteratingOperation.PartitionResponse();
                    }
                    case 5: {
                        return new BinaryOperationFactory();
                    }
                    case 6: {
                        return new EventServiceImpl.EventPacket();
                    }
                    case 7: {
                        return new SerializableCollection();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public int getFactoryId() {
        return F_ID;
    }
}

