/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations;

import com.hazelcast.multimap.MultiMapRecord;
import com.hazelcast.multimap.MultiMapWrapper;
import com.hazelcast.multimap.operations.MultiMapKeyBasedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class RemoveBackupOperation
extends MultiMapKeyBasedOperation
implements BackupOperation {
    long recordId;

    public RemoveBackupOperation() {
    }

    public RemoveBackupOperation(String name, Data dataKey, long recordId) {
        super(name, dataKey);
        this.recordId = recordId;
    }

    @Override
    public void run() throws Exception {
        MultiMapWrapper wrapper = this.getCollectionWrapper();
        this.response = false;
        if (wrapper == null) {
            return;
        }
        Collection<MultiMapRecord> coll = wrapper.getCollection(false);
        Iterator<MultiMapRecord> iter = coll.iterator();
        while (iter.hasNext()) {
            if (iter.next().getRecordId() != this.recordId) continue;
            iter.remove();
            this.response = true;
            if (!coll.isEmpty()) break;
            this.delete();
            break;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.recordId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.recordId = in.readLong();
    }

    @Override
    public int getId() {
        return 19;
    }
}

