/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs.authz;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.acls.domain.DefaultPermissionFactory;
import org.springframework.security.acls.domain.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.domain.SidRetrievalStrategyImpl;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.SidRetrievalStrategy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.ExpressionEvaluationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlListTag
extends TagSupport {
    protected static final Log logger = LogFactory.getLog(AccessControlListTag.class);
    private AclService aclService;
    private ApplicationContext applicationContext;
    private Object domainObject;
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy;
    private SidRetrievalStrategy sidRetrievalStrategy;
    private PermissionFactory permissionFactory;
    private String hasPermission = "";

    public int doStartTag() throws JspException {
        if (null == this.hasPermission || "".equals(this.hasPermission)) {
            return 0;
        }
        this.initializeIfRequired();
        String evaledPermissionsString = ExpressionEvaluationUtils.evaluateString((String)"hasPermission", (String)this.hasPermission, (PageContext)this.pageContext);
        List<Permission> requiredPermissions = this.parsePermissionsString(evaledPermissionsString);
        Object resolvedDomainObject = null;
        resolvedDomainObject = this.domainObject instanceof String ? ExpressionEvaluationUtils.evaluate((String)"domainObject", (String)((String)this.domainObject), Object.class, (PageContext)this.pageContext) : this.domainObject;
        if (resolvedDomainObject == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"domainObject resolved to null, so including tag body");
            }
            return 1;
        }
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"SecurityContextHolder did not return a non-null Authentication object, so skipping tag body");
            }
            return 0;
        }
        List sids = this.sidRetrievalStrategy.getSids(SecurityContextHolder.getContext().getAuthentication());
        ObjectIdentity oid = this.objectIdentityRetrievalStrategy.getObjectIdentity(resolvedDomainObject);
        try {
            Acl acl = this.aclService.readAclById(oid, sids);
            if (acl.isGranted(requiredPermissions, sids, false)) {
                return 1;
            }
            return 0;
        }
        catch (NotFoundException nfe) {
            return 0;
        }
    }

    protected ApplicationContext getContext(PageContext pageContext) {
        ServletContext servletContext = pageContext.getServletContext();
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
    }

    public Object getDomainObject() {
        return this.domainObject;
    }

    public String getHasPermission() {
        return this.hasPermission;
    }

    private void initializeIfRequired() throws JspException {
        if (this.applicationContext != null) {
            return;
        }
        this.applicationContext = this.getContext(this.pageContext);
        this.aclService = this.getBeanOfType(AclService.class);
        this.sidRetrievalStrategy = this.getBeanOfType(SidRetrievalStrategy.class);
        if (this.sidRetrievalStrategy == null) {
            this.sidRetrievalStrategy = new SidRetrievalStrategyImpl();
        }
        this.objectIdentityRetrievalStrategy = this.getBeanOfType(ObjectIdentityRetrievalStrategy.class);
        if (this.objectIdentityRetrievalStrategy == null) {
            this.objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
        }
        this.permissionFactory = this.getBeanOfType(PermissionFactory.class);
        if (this.permissionFactory == null) {
            this.permissionFactory = new DefaultPermissionFactory();
        }
    }

    private <T> T getBeanOfType(Class<T> type) throws JspException {
        Map map = this.applicationContext.getBeansOfType(type);
        for (ApplicationContext context = this.applicationContext.getParent(); context != null; context = context.getParent()) {
            map.putAll(context.getBeansOfType(type));
        }
        if (map.size() == 0) {
            return null;
        }
        if (map.size() == 1) {
            return (T)map.values().iterator().next();
        }
        throw new JspException("Found incorrect number of " + type.getSimpleName() + " instances in " + "application context - you must have only have one!");
    }

    private List<Permission> parsePermissionsString(String permissionsString) throws NumberFormatException {
        HashSet<Permission> permissions = new HashSet<Permission>();
        StringTokenizer tokenizer = new StringTokenizer(permissionsString, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String permission = tokenizer.nextToken();
            try {
                permissions.add(this.permissionFactory.buildFromMask(Integer.valueOf(permission).intValue()));
            }
            catch (NumberFormatException nfe) {
                permissions.add(this.permissionFactory.buildFromName(permission));
            }
        }
        return new ArrayList<Permission>(permissions);
    }

    public void setDomainObject(Object domainObject) {
        this.domainObject = domainObject;
    }

    public void setHasPermission(String hasPermission) {
        this.hasPermission = hasPermission;
    }
}

