/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec.keys;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.ec.keys.ECPrivateKeySpec;
import de.flexiprovider.ec.parameters.CurveParams;
import de.flexiprovider.ec.parameters.ECParameters;
import java.util.ArrayList;

public class ECPrivateKey
extends PrivateKey {
    private FlexiBigInt mS;
    private CurveParams mParams;

    protected ECPrivateKey(FlexiBigInt s, CurveParams params) {
        this.mS = s;
        this.mParams = params;
    }

    protected ECPrivateKey(ECPrivateKeySpec keySpec) {
        this(keySpec.getS(), keySpec.getParams());
    }

    public FlexiBigInt getS() {
        return this.mS;
    }

    public String getAlgorithm() {
        return "EC";
    }

    public String toString() {
        return "s = " + this.mS.toString(16) + "\n" + this.mParams.toString();
    }

    public CurveParams getParams() {
        return this.mParams;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ECPrivateKey)) {
            return false;
        }
        ECPrivateKey oKey = (ECPrivateKey)obj;
        boolean value = oKey.mS.equals(this.mS);
        return value &= this.mParams.equals(oKey.mParams);
    }

    public int hashCode() {
        return this.mS.hashCode() + this.mParams.getR().hashCode() + this.mParams.getQ().hashCode();
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier("1.2.840.10045.2.1");
    }

    protected ASN1Type getAlgParams() {
        Object algParams = this.mParams.getOID();
        if (algParams == null) {
            ECParameters ecParams = new ECParameters();
            try {
                ecParams.init(this.mParams);
            }
            catch (InvalidParameterSpecException e) {
                throw new RuntimeException("internal error");
            }
            algParams = ecParams.getASN1Params();
        }
        return algParams;
    }

    protected byte[] getKeyData() {
        byte[] keyBytes = this.mS.toByteArray();
        ECASN1PrivateKey keyData = new ECASN1PrivateKey(1, new ASN1OctetString(keyBytes));
        return ASN1Tools.derEncode((ASN1Type)keyData);
    }

    private static class ECASN1PrivateKey
    extends ASN1Sequence {
        private ASN1Integer version;
        private ASN1OctetString privKey;

        public ECASN1PrivateKey(int version, ASN1OctetString privKey) {
            super(2);
            this.version = new ASN1Integer(version);
            this.privKey = privKey;
            ((ArrayList)((Object)this)).add(this.version);
            ((ArrayList)((Object)this)).add(privKey);
        }

        public ASN1OctetString getPrivateKey() {
            return this.privKey;
        }
    }
}

