/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec;

import de.flexiprovider.api.KeyAgreement;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.NoSuchAlgorithmException;
import de.flexiprovider.api.exceptions.ShortBufferException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.PrivateKey;
import de.flexiprovider.api.keys.PublicKey;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.exceptions.InvalidPointException;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.common.math.ellipticcurves.ScalarMult;
import de.flexiprovider.ec.ECTools;
import de.flexiprovider.ec.keys.ECPrivateKey;
import de.flexiprovider.ec.keys.ECPublicKey;
import de.flexiprovider.ec.keys.ECSecretKey;

public class ECSVDPDHC
extends KeyAgreement {
    private FlexiBigInt mS;
    private ECPublicKey mOtherKey;
    protected boolean withCoFactor = true;
    private FlexiBigInt mK;

    public void init(PrivateKey key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        ECPrivateKey ecPrivKey = (ECPrivateKey)key;
        this.mS = ecPrivKey.getS();
        this.mK = FlexiBigInt.valueOf(ecPrivKey.getParams().getK());
    }

    public void init(PrivateKey key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        ECPrivateKey ecPrivKey = (ECPrivateKey)key;
        this.mS = ecPrivKey.getS();
        this.mK = FlexiBigInt.valueOf(ecPrivKey.getParams().getK());
    }

    public SecretKey generateSecret(String algorithm) throws NoSuchAlgorithmException {
        ECSecretKey secr = null;
        if (!algorithm.equals("ECDH")) {
            throw new NoSuchAlgorithmException(algorithm + " is not supported");
        }
        try {
            secr = this.secretGenerator();
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Can't generate shared secret: " + ex.getMessage());
        }
        return secr;
    }

    public int generateSecret(byte[] sharedSecret, int offset) throws ShortBufferException {
        ECSecretKey secr = null;
        try {
            secr = this.secretGenerator();
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Can't generate shared secret: " + ex.getMessage());
        }
        byte[] sByte = secr.getS().toByteArray();
        int n = sByte.length;
        try {
            System.arraycopy(sByte, 0, sharedSecret, offset, n);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ShortBufferException("Byte array sharedSecret too small for shared secret.");
        }
        return n;
    }

    public byte[] generateSecret() {
        ECSecretKey secr = null;
        try {
            secr = this.secretGenerator();
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Can't generate shared secret: " + ex.getMessage());
        }
        return secr.getS().toByteArray();
    }

    public Key doPhase(PublicKey key, boolean lastPhase) throws InvalidKeyException {
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        this.mOtherKey = (ECPublicKey)key;
        if (!ECTools.isValidPublicKey(this.mOtherKey)) {
            throw new InvalidKeyException("invalid key");
        }
        try {
            if (lastPhase) {
                return this.generateSecret("ECDH");
            }
            return null;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("internal error");
        }
    }

    private ECSecretKey secretGenerator() throws InvalidKeyException {
        Point q = this.mOtherKey.getW();
        q = ScalarMult.multiply(this.mS, q);
        if (this.withCoFactor) {
            q = ScalarMult.multiply(this.mK, q);
        }
        if (q.isZero()) {
            throw new InvalidPointException("shared secret is invalid");
        }
        return new ECSecretKey(q.getXAffin().toFlexiBigInt());
    }
}

