/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.initializer;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.initializer.SmackAndOsgiInitializer;
import org.jivesoftware.smack.provider.ProviderFileLoader;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.FileUtils;

public abstract class UrlInitializer
extends SmackAndOsgiInitializer {
    private static final Logger LOGGER = Logger.getLogger(UrlInitializer.class.getName());

    @Override
    public List<Exception> initialize() {
        return this.initialize(this.getClass().getClassLoader());
    }

    @Override
    public List<Exception> initialize(ClassLoader classLoader) {
        String configUrl;
        InputStream is;
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        String providerUrl = this.getProvidersUrl();
        if (providerUrl != null) {
            try {
                is = FileUtils.getStreamForUrl((String)providerUrl, (ClassLoader)classLoader);
                if (is != null) {
                    LOGGER.log(Level.FINE, "Loading providers for providerUrl [" + providerUrl + "]");
                    ProviderFileLoader pfl = new ProviderFileLoader(is, classLoader);
                    ProviderManager.addLoader((ProviderLoader)pfl);
                    exceptions.addAll(pfl.getLoadingExceptions());
                } else {
                    LOGGER.log(Level.WARNING, "No input stream created for " + providerUrl);
                    exceptions.add(new IOException("No input stream created for " + providerUrl));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error trying to load provider file " + providerUrl, e);
                exceptions.add(e);
            }
        }
        if ((configUrl = this.getConfigUrl()) != null) {
            try {
                is = FileUtils.getStreamForUrl((String)configUrl, (ClassLoader)classLoader);
                SmackConfiguration.processConfigFile((InputStream)is, exceptions, (ClassLoader)classLoader);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    protected String getProvidersUrl() {
        return null;
    }

    protected String getConfigUrl() {
        return null;
    }
}

