/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1Boolean;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.Decoder;
import codec.x509.X509Extension;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;

public class BasicConstraintsExtension
extends X509Extension {
    public static final String ID_CE_BASIC_CONSTRAINTS = "2.5.29.19";
    protected ASN1Boolean cA;
    protected ASN1Integer pathLenConstraints;
    protected ASN1Sequence basicConstraintsSyntax;

    public BasicConstraintsExtension() throws Exception {
        this(false, -1);
    }

    public BasicConstraintsExtension(boolean _cA, int _pathLenConstraints) throws Exception {
        this.setOID(new ASN1ObjectIdentifier(ID_CE_BASIC_CONSTRAINTS));
        this.setCritical(true);
        this.cA = new ASN1Boolean(_cA);
        this.cA.setOptional(false);
        if (_cA && _pathLenConstraints >= 0) {
            this.pathLenConstraints = new ASN1Integer(_pathLenConstraints);
            this.pathLenConstraints.setOptional(false);
        } else {
            this.pathLenConstraints = new ASN1Integer();
            this.pathLenConstraints.setOptional(true);
        }
        this.basicConstraintsSyntax = new ASN1Sequence();
        if (_cA) {
            this.basicConstraintsSyntax.add(this.cA);
            this.basicConstraintsSyntax.add(this.pathLenConstraints);
        }
        this.setValue(this.basicConstraintsSyntax);
    }

    public BasicConstraintsExtension(byte[] ext) throws ASN1Exception, IOException {
        super(ext);
    }

    public boolean isCA() {
        return this.cA.isTrue();
    }

    public int getPathLenConstraints() {
        if (this.pathLenConstraints.isOptional()) {
            return -1;
        }
        return this.pathLenConstraints.getBigInteger().intValue();
    }

    public void setCA(boolean _cA) throws CertificateEncodingException {
        this.cA.setTrue(_cA);
        if (!_cA) {
            this.pathLenConstraints.setOptional(true);
        }
        this.setValue(this.basicConstraintsSyntax);
    }

    public void setPathLenConstraints(int pathLenConstraints) throws Exception {
        if (pathLenConstraints >= 0) {
            this.pathLenConstraints.setBigInteger(new BigInteger(Integer.toString(pathLenConstraints)));
            this.pathLenConstraints.setOptional(false);
        } else {
            this.pathLenConstraints.setOptional(true);
        }
        this.setValue(this.basicConstraintsSyntax);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        super.decode(dec);
        super.decodeExtensionValue(this.basicConstraintsSyntax);
    }

    public String toString(String offset) {
        StringBuffer buf = new StringBuffer(offset + "BasicConstraintsExtension [" + this.getOID() + "] {");
        if (this.isCritical()) {
            buf.append(" (CRITICAL)\n");
        } else {
            buf.append(" (NOT CRITICAL)\n");
        }
        buf.append(offset + "  cA: " + this.cA.toString() + "\n");
        if (!this.pathLenConstraints.isOptional()) {
            buf.append(offset + "  pathLenConstraints: " + this.pathLenConstraints.toString() + "\n");
        } else {
            buf.append(offset + "  No pathLenConstraints\n");
        }
        buf.append(offset + "}\n");
        return buf.toString();
    }
}

