/*
 * Decompiled with CFR 0.152.
 */
package codec.x509.extensions;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.ASN1TaggedType;
import codec.asn1.Decoder;
import codec.x509.GeneralName;
import codec.x509.X509Extension;
import java.io.IOException;
import java.math.BigInteger;

public class AuthorityKeyIdentifierExtension
extends X509Extension {
    public static final String ID_CE_AUTHORITY_KEY_IDENTIFIER = "2.5.29.35";
    protected ASN1Sequence authorityKeyIdentifier = new ASN1Sequence(3);
    public static final int KEY_IDENTIFIER_TYPE = 0;
    private ASN1TaggedType keyIdentifierTag;
    private ASN1OctetString keyIdentifier;
    public static final int CERT_ISSUER_TYPE = 1;
    private ASN1TaggedType certIssuerTag;
    private ASN1SequenceOf certIssuer;
    public static final int CERT_SERIAL_NUMBER_TYPE = 2;
    private ASN1TaggedType certSerialNumberTag;
    protected ASN1Integer certSerialNumber;
    static /* synthetic */ Class class$codec$x509$GeneralName;

    public AuthorityKeyIdentifierExtension() throws Exception {
        this.setOID(new ASN1ObjectIdentifier(ID_CE_AUTHORITY_KEY_IDENTIFIER));
        this.setCritical(false);
        this.keyIdentifier = new ASN1OctetString();
        this.keyIdentifierTag = new ASN1TaggedType(0, this.keyIdentifier, false, true);
        this.authorityKeyIdentifier.add(this.keyIdentifierTag);
        this.certIssuer = new ASN1SequenceOf(class$codec$x509$GeneralName == null ? (class$codec$x509$GeneralName = AuthorityKeyIdentifierExtension.class$("codec.x509.GeneralName")) : class$codec$x509$GeneralName);
        this.certIssuerTag = new ASN1TaggedType(1, this.certIssuer, false, true);
        this.authorityKeyIdentifier.add(this.certIssuerTag);
        this.certSerialNumber = new ASN1Integer();
        this.certSerialNumberTag = new ASN1TaggedType(2, this.certSerialNumber, false, true);
        this.authorityKeyIdentifier.add(this.certSerialNumberTag);
        this.setValue(this.authorityKeyIdentifier);
    }

    public AuthorityKeyIdentifierExtension(byte[] ext) throws ASN1Exception, IOException {
        super(ext);
    }

    public void setKeyIdentifier(byte[] identifier) throws Exception {
        this.keyIdentifier.setByteArray(identifier);
        this.keyIdentifierTag.setOptional(false);
        this.setValue(this.authorityKeyIdentifier);
    }

    public void addCertIssuer(GeneralName generalName) throws Exception {
        this.certIssuer.add(generalName);
        this.certIssuerTag.setOptional(false);
        this.setValue(this.authorityKeyIdentifier);
    }

    public void setCertSerialNumber(BigInteger serialNumber) throws Exception {
        this.certSerialNumber.setBigInteger(serialNumber);
        this.certSerialNumberTag.setOptional(false);
        this.setValue(this.authorityKeyIdentifier);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        super.decode(dec);
        super.decodeExtensionValue(this.authorityKeyIdentifier);
    }

    public String toString(String offset) {
        StringBuffer buf = new StringBuffer(offset + "AuthorityKeyIdentifier [" + this.getOID() + "] {");
        if (this.isCritical()) {
            buf.append(" (CRITICAL)\n");
        } else {
            buf.append(" (NOT CRITICAL)\n");
        }
        if (!this.keyIdentifierTag.isOptional()) {
            buf.append(offset + "  keyIdentifier: " + this.keyIdentifier + "\n");
        }
        if (!this.certIssuerTag.isOptional()) {
            buf.append(offset + "  certIssuers: " + this.certIssuer + "\n");
        }
        if (!this.certSerialNumberTag.isOptional()) {
            buf.append(offset + "  certSerialNumber: " + this.certSerialNumber + "\n");
        }
        buf.append(offset + "}\n");
        return buf.toString();
    }

    public String toString() {
        return this.toString("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

