/*
 * Decompiled with CFR 0.152.
 */
package codec.x509;

import codec.asn1.ASN1Boolean;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import codec.asn1.ConstraintException;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.HashSet;
import java.util.Set;

public class X509Extension
extends ASN1Sequence
implements java.security.cert.X509Extension,
Externalizable {
    protected ASN1ObjectIdentifier extnID = new ASN1ObjectIdentifier();
    protected ASN1Boolean critical = null;
    protected ASN1OctetString extnValue = null;

    public X509Extension() {
        this.add(this.extnID);
        this.critical = new ASN1Boolean(false);
        this.critical.setOptional(true);
        this.add(this.critical);
        this.extnValue = new ASN1OctetString();
        this.add(this.extnValue);
    }

    public X509Extension(byte[] b) throws ASN1Exception, IOException {
        this();
        if (b == null) {
            throw new NullPointerException("input array");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        DERDecoder dec = new DERDecoder(in);
        this.decode(dec);
        in.close();
    }

    public X509Extension(ASN1ObjectIdentifier theoid, boolean crit, ASN1Type val) throws Exception {
        this();
        this.setOID(theoid);
        this.setCritical(crit);
        this.setValue(val);
    }

    public Set getCriticalExtensionOIDs() {
        HashSet<ASN1ObjectIdentifier> res = new HashSet<ASN1ObjectIdentifier>();
        if (this.isCritical()) {
            res.add(this.getOID());
        }
        return res;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEREncoder enc = new DEREncoder(bos);
        try {
            this.encode(enc);
            bos.close();
        }
        catch (IOException e) {
            System.err.println("getenc Internal error: shouldn't happen!");
            e.printStackTrace();
        }
        catch (ASN1Exception e) {
            throw new CertificateEncodingException(e.getMessage());
        }
        return bos.toByteArray();
    }

    public byte[] getExtensionValue(String oid) {
        byte[] res = null;
        if (this.extnValue == null) {
            return null;
        }
        if (this.extnID.toString().equals(oid) || this.extnID.toString().equals(new String("OID." + oid))) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DEREncoder enc = new DEREncoder(baos);
                this.extnValue.encode(enc);
                res = baos.toByteArray();
                baos.close();
            }
            catch (ASN1Exception asn1e) {
                throw new IllegalStateException("Caught ASN1Exception. Internal Error. Shouldn't happen");
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Internal Error. Shouldn't happen");
            }
        }
        return res;
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet<ASN1ObjectIdentifier> res = new HashSet<ASN1ObjectIdentifier>();
        if (!this.isCritical()) {
            res.add(this.getOID());
        }
        return res;
    }

    public ASN1ObjectIdentifier getOID() {
        return this.extnID;
    }

    public Object getValue() {
        ASN1Type res = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.extnValue.getByteArray());
            DERDecoder dec = new DERDecoder(bis);
            res = dec.readType();
            dec.close();
        }
        catch (IOException e) {
            System.err.println("Internal error: shouldn't happen!");
            e.printStackTrace();
        }
        catch (ASN1Exception e) {
            res = this.extnValue;
        }
        return res;
    }

    protected void decodeExtensionValue(ASN1Type t) throws ASN1Exception, IOException {
        if (t == null) {
            throw new NullPointerException("input parameter");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(this.extnValue.getByteArray());
        DERDecoder dec = new DERDecoder(bis);
        t.decode(dec);
        dec.close();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (!this.isCritical()) {
            return false;
        }
        return false;
    }

    public boolean isCritical() {
        if (this.isOptional()) {
            return false;
        }
        return this.critical.isTrue();
    }

    public void setCritical(boolean ncrit) {
        if (!ncrit) {
            this.critical.setOptional(true);
        } else {
            this.critical.setTrue(ncrit);
            this.critical.setOptional(false);
        }
    }

    public void setOID(ASN1ObjectIdentifier noid) throws ConstraintException {
        this.extnID.setOID(noid.getOID());
    }

    public void setValue(ASN1Type nval) throws CertificateEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            nval.encode(new DEREncoder(baos));
            this.extnValue.setByteArray(baos.toByteArray());
        }
        catch (Exception e) {
            throw new CertificateEncodingException(e.getMessage());
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String offset) {
        String res = offset;
        res = "Extension " + this.extnID.toString();
        res = this.critical.isTrue() ? res + " (CRITICAL)" : res + " (not critical)";
        res = res + " Value=" + this.getValue().toString();
        return res;
    }
}

