/*
 * Decompiled with CFR 0.152.
 */
package codec.x509;

import codec.asn1.ASN1Choice;
import codec.asn1.ASN1IA5String;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1OpenType;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Type;
import codec.asn1.ConstraintException;
import codec.x501.BadNameException;
import codec.x501.Name;
import codec.x509.X509Exception;
import java.security.InvalidParameterException;

public class GeneralName
extends ASN1Choice {
    public static final int TYPE_OTHER_NAME = 0;
    private ASN1TaggedType otherName_;
    private ASN1Sequence otherNameSequence_;
    private ASN1ObjectIdentifier otherNameID_ = new ASN1ObjectIdentifier();
    private ASN1TaggedType otherNameValueTag_;
    private ASN1OpenType otherNameValue_ = new ASN1OpenType();
    public static final int TYPE_RFC822_NAME = 1;
    private ASN1IA5String rfc822N_;
    private ASN1TaggedType rfc822Name_;
    public static final int TYPE_DNS_NAME = 2;
    private ASN1IA5String dNSN_;
    private ASN1TaggedType dNSName_;
    public static final int TYPE_X400_ADDRESS = 3;
    public static final int TYPE_DIRECTORY_NAME = 4;
    private Name dirN_;
    private ASN1TaggedType directoryName_;
    public static final int TYPE_EDI_PARTY_NAME = 5;
    public static final int TYPE_UNIFORM_RESOURCE_IDENTIFIER = 6;
    private ASN1IA5String uniformResourceId_;
    private ASN1TaggedType uniformResourceIdentifier_;
    public static final int TYPE_IP_ADDRESS = 7;
    private ASN1OctetString iPAdr_;
    private ASN1TaggedType iPAddress_;
    public static final int TYPE_REGISTERED_ID = 8;
    private ASN1ObjectIdentifier regID_;
    private ASN1TaggedType registeredID_;

    public GeneralName() {
        this.otherNameValueTag_ = new ASN1TaggedType(0, this.otherNameValue_, true, false);
        this.otherNameSequence_ = new ASN1Sequence();
        this.otherNameSequence_.add(this.otherNameID_);
        this.otherNameSequence_.add(this.otherNameValueTag_);
        this.otherName_ = new ASN1TaggedType(0, this.otherNameSequence_, false, false);
        this.addType(this.otherName_);
        this.rfc822N_ = new ASN1IA5String();
        this.rfc822Name_ = new ASN1TaggedType(1, this.rfc822N_, false, false);
        this.addType(this.rfc822Name_);
        this.dNSN_ = new ASN1IA5String();
        this.dNSName_ = new ASN1TaggedType(2, this.dNSN_, false, false);
        this.addType(this.dNSName_);
        this.dirN_ = new Name();
        this.directoryName_ = new ASN1TaggedType(4, this.dirN_, true, false);
        this.addType(this.directoryName_);
        this.uniformResourceId_ = new ASN1IA5String();
        this.uniformResourceIdentifier_ = new ASN1TaggedType(6, this.uniformResourceId_, false, false);
        this.addType(this.uniformResourceIdentifier_);
        this.iPAdr_ = new ASN1OctetString();
        this.iPAddress_ = new ASN1TaggedType(7, this.iPAdr_, false, false);
        this.addType(this.iPAddress_);
        this.regID_ = new ASN1ObjectIdentifier();
        this.registeredID_ = new ASN1TaggedType(8, this.regID_, false, false);
        this.addType(this.registeredID_);
    }

    public ASN1Type getGeneralName() throws X509Exception {
        int tag = this.getTag();
        ASN1TaggedType inner = (ASN1TaggedType)this.getInnerType();
        switch (tag) {
            case 0: {
                return inner.getInnerType();
            }
            case 1: {
                return inner.getInnerType();
            }
            case 2: {
                return inner.getInnerType();
            }
            case 3: {
                throw new X509Exception("x400Address not yet supported!");
            }
            case 4: {
                return inner.getInnerType();
            }
            case 5: {
                throw new X509Exception("ediPartyName not yet supported!");
            }
            case 6: {
                return inner.getInnerType();
            }
            case 7: {
                return inner.getInnerType();
            }
            case 8: {
                return inner.getInnerType();
            }
        }
        throw new X509Exception("Tag not supported for GeneralName: " + tag);
    }

    public void setDirectoryName(Name dirname) {
        try {
            this.dirN_ = new Name(dirname.getName(), -1);
        }
        catch (BadNameException e) {
            throw new IllegalStateException("INTERNAL ERROR");
        }
        this.dirN_.setExplicit(true);
        this.directoryName_.setInnerType(this.dirN_);
        this.setInnerType(this.directoryName_);
    }

    public void setDNSName(ASN1IA5String dnsname) {
        this.dNSN_ = new ASN1IA5String(new String(dnsname.getString()));
        this.dNSN_.setExplicit(false);
        this.dNSName_.setInnerType(this.dNSN_);
        this.setInnerType(this.dNSName_);
    }

    public void setIPAddress(byte[] address) throws InvalidParameterException {
        if (address.length != 8 && address.length != 32 && address.length != 4 && address.length != 16) {
            throw new InvalidParameterException("IP-Adress must be either 4,8,16 or 32 bytes!");
        }
        try {
            this.iPAdr_.setByteArray(address);
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
        this.setInnerType(this.iPAddress_);
    }

    public void setRegisteredID(ASN1ObjectIdentifier oid) {
        this.regID_ = new ASN1ObjectIdentifier(oid.getOID());
        this.regID_.setExplicit(false);
        this.registeredID_.setInnerType(this.regID_);
        this.setInnerType(this.registeredID_);
    }

    public void setRfc822Name(ASN1IA5String rfcname) {
        this.rfc822N_ = new ASN1IA5String(new String(rfcname.getString()));
        this.rfc822N_.setExplicit(false);
        this.rfc822Name_.setInnerType(this.rfc822N_);
        this.setInnerType(this.rfc822Name_);
    }

    public void setUniformResourceIdentifier(ASN1IA5String unirid) {
        this.uniformResourceId_ = new ASN1IA5String(new String(unirid.getString()));
        this.uniformResourceId_.setExplicit(false);
        this.uniformResourceIdentifier_.setInnerType(this.uniformResourceId_);
        this.setInnerType(this.uniformResourceIdentifier_);
    }

    public String toString() {
        StringBuffer res = new StringBuffer("GeneralName {\n");
        try {
            res.append(this.getGeneralName().toString());
        }
        catch (Exception e) {
            res.append("Caught Exception " + e.getMessage());
            e.printStackTrace();
        }
        res.append("\n}");
        return res.toString();
    }
}

