/*
 * Decompiled with CFR 0.152.
 */
package codec.x501;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1IA5String;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OpenType;
import codec.asn1.ASN1PrintableString;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.ASN1Set;
import codec.asn1.ASN1SetOf;
import codec.asn1.ASN1String;
import codec.asn1.ASN1T61String;
import codec.asn1.ASN1Type;
import codec.asn1.ASN1UTF8String;
import codec.asn1.BERDecoder;
import codec.asn1.DEREncoder;
import codec.asn1.Decoder;
import codec.asn1.Resolver;
import codec.x501.AVA;
import codec.x501.BadNameException;
import codec.x501.RFC2253Parser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Name
extends ASN1SequenceOf
implements Principal,
Resolver {
    private static final long serialVersionUID = 1L;
    public static final String MATCH_ALL = "*";
    public static final int IA5_ENCODING = 22;
    public static final int PRINTABLE_ENCODING = 19;
    public static final int T61_ENCODING = 20;
    public static final int UTF8_ENCODING = 12;
    protected static final boolean allowDefaultEncoding_ = true;
    protected static int defaultEncoding_ = 19;
    private int currentEncoding_ = defaultEncoding_;
    static final String[] keys_ = new String[]{"ALIASEDOBJECTNAME", "C", "CN", "DC", "DATEOFBIRTH", "DNQUALIFIER", "DESCRIPTION", "EMAILADDRESS", "GENDER", "GENERATION", "GN", "INITIALS", "IP", "L", "O", "OU", "PLACEOFBIRTH", "POSTALADDRESS", "POSTALCODE", "PSEUDONYM", "SERIALNUMBER", "SN", "ST", "STREET", "UID", "TITLE"};
    static final int[][] oids_ = new int[][]{{2, 5, 4, 1}, {2, 5, 4, 6}, {2, 5, 4, 3}, {0, 9, 2342, 19200300, 100, 1, 25}, {1, 3, 6, 1, 5, 5, 7, 9, 1}, {2, 5, 4, 46}, {2, 5, 4, 13}, {1, 2, 840, 113549, 1, 9, 1}, {1, 3, 6, 1, 5, 5, 7, 9, 3}, {2, 5, 4, 44}, {2, 5, 4, 42}, {2, 5, 4, 43}, {1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1}, {2, 5, 4, 7}, {2, 5, 4, 10}, {2, 5, 4, 11}, {1, 3, 6, 1, 5, 5, 7, 9, 2}, {2, 5, 4, 16}, {2, 5, 4, 17}, {2, 5, 4, 65}, {2, 5, 4, 5}, {2, 5, 4, 4}, {2, 5, 4, 8}, {2, 5, 4, 9}, {0, 9, 2342, 19200300, 100, 1, 1}, {2, 5, 4, 12}};
    protected HashMap a2oid_;
    protected HashMap oid2a_;
    private String name_;
    private String rname_;
    List tmp_;

    public static void setEncodingType(int encType) throws BadNameException {
        if (encType != 12 && encType != 20 && encType != 19 && encType != 22) {
            throw new BadNameException("Unknown EncodingType: " + encType);
        }
        defaultEncoding_ = encType;
    }

    public static int getEncodingType() {
        return defaultEncoding_;
    }

    public Name() {
        super(8);
        this.initMaps();
    }

    public Name(String rfc2253String) throws BadNameException {
        this(rfc2253String, -1);
    }

    public Name(String rfc2253String, int encType) throws BadNameException {
        super(8);
        this.initMaps();
        if (encType == -1) {
            this.currentEncoding_ = defaultEncoding_;
        } else {
            if (encType != 12 && encType != 20 && encType != 19 && encType != 22) {
                throw new BadNameException("Unknown EncodingType: " + encType);
            }
            this.currentEncoding_ = encType;
        }
        RFC2253Parser p = new RFC2253Parser();
        ASN1Set set = new ASN1Set(1);
        Iterator i = p.parse(rfc2253String).iterator();
        while (i.hasNext()) {
            AVA entry = (AVA)i.next();
            String key = entry.getKey();
            key = key.toUpperCase();
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)this.a2oid_.get(key);
            ASN1Sequence seq = new ASN1Sequence(2);
            if (oid == null) {
                try {
                    oid = new ASN1ObjectIdentifier(key);
                }
                catch (Exception e) {
                    throw new BadNameException("Unsupported attribute key: \"" + key + "\"");
                }
            }
            seq.add(oid.clone());
            if (entry.isEncodedValue()) {
                ASN1Type obj;
                try {
                    byte[] buf = entry.getEncodedValue();
                    ByteArrayInputStream in = new ByteArrayInputStream(buf);
                    BERDecoder dec = new BERDecoder(in);
                    obj = dec.readType();
                    dec.close();
                }
                catch (Exception e) {
                    throw new BadNameException("Binary data is not a valid BER encoding!");
                }
                seq.add(obj);
            } else {
                String val = entry.getValue();
                if (entry.getKey().equalsIgnoreCase("EMAILADDRESS") || entry.getKey().equalsIgnoreCase("UID")) {
                    seq.add(new ASN1IA5String(val));
                } else if (entry.getKey().equalsIgnoreCase("C") || entry.getKey().equalsIgnoreCase("SERIALNUMBER")) {
                    seq.add(new ASN1PrintableString(val));
                } else {
                    switch (this.currentEncoding_) {
                        case 12: {
                            seq.add(new ASN1UTF8String(val));
                            break;
                        }
                        case 22: {
                            seq.add(new ASN1IA5String(val));
                            break;
                        }
                        case 19: {
                            if (this.checkPrintableSpelling(val)) {
                                seq.add(new ASN1PrintableString(val));
                                break;
                            }
                            throw new BadNameException("Illegal characters for PrintableString in characters");
                        }
                        case 20: {
                            seq.add(new ASN1T61String(val));
                        }
                    }
                }
            }
            set.add(seq);
            if (entry.hasSibling()) continue;
            set.trimToSize();
            super.add(0, set);
            set = new ASN1Set(1);
        }
        this.trimToSize();
    }

    public void clear() {
        super.clear();
        if (this.tmp_ != null) {
            this.tmp_.clear();
        }
    }

    public boolean registerOID(int[] oid, String key) {
        ASN1ObjectIdentifier objectID = new ASN1ObjectIdentifier(oid);
        String keyUC = key.toUpperCase();
        if (this.a2oid_.get(keyUC) != null || this.oid2a_.get(objectID) != null) {
            return false;
        }
        this.a2oid_.put(keyUC, objectID);
        this.oid2a_.put(objectID, keyUC);
        return true;
    }

    public Map getOIDs() {
        return Collections.unmodifiableMap(this.oid2a_);
    }

    public void resetOIDs() {
        this.initMaps();
    }

    protected void initMaps() {
        if (this.a2oid_ == null) {
            this.a2oid_ = new HashMap();
            this.oid2a_ = new HashMap();
            int i = 0;
            while (i < keys_.length) {
                ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(oids_[i]);
                this.a2oid_.put(keys_[i], oid);
                this.oid2a_.put(oid, keys_[i]);
                ++i;
            }
        }
    }

    public int getCurrentEncoding() {
        return this.currentEncoding_;
    }

    private boolean checkPrintableSpelling(String val) {
        boolean result = true;
        char[] allowed = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 (),-./:=?".toCharArray();
        char[] value = val.toCharArray();
        int i = 0;
        while (i < value.length) {
            int j = 0;
            while (j < allowed.length) {
                if (value[i] == allowed[j]) break;
                if (j == allowed.length - 1) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        if (this.name_ != null) {
            return this.name_;
        }
        StringBuffer buf = new StringBuffer();
        Iterator it = this.getAVAList().iterator();
        while (it.hasNext()) {
            AVA entry = (AVA)it.next();
            buf.insert(0, entry.toString());
            if (!it.hasNext()) continue;
            if (entry.hasSibling()) {
                buf.insert(0, " + ");
                continue;
            }
            buf.insert(0, ", ");
        }
        return buf.toString();
    }

    public List getAVAList() {
        ArrayList<AVA> list = new ArrayList<AVA>(this.size());
        Iterator i = ((AbstractList)this).iterator();
        while (i.hasNext()) {
            ASN1Set rdn = (ASN1Set)i.next();
            int n = rdn.size();
            int j = 0;
            while (j < n) {
                AVA entry;
                boolean sibling = j < n - 1;
                ASN1Sequence ava = (ASN1Sequence)rdn.get(j);
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)ava.get(0);
                ASN1Type obj = (ASN1Type)ava.get(1);
                String key = (String)this.oid2a_.get(oid);
                if (key == null) {
                    key = oid.toString();
                }
                if (obj instanceof ASN1String) {
                    String val = ((ASN1String)obj).getString();
                    entry = new AVA(key, val, sibling);
                } else {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        DEREncoder enc = new DEREncoder(out);
                        obj.encode(enc);
                        entry = new AVA(key, out.toByteArray(), sibling);
                        enc.close();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot BER encode!");
                    }
                }
                list.add(entry);
                ++j;
            }
        }
        return list;
    }

    public List getReverseAVAList() {
        ArrayList<AVA> list = new ArrayList<AVA>(this.size());
        int i = this.size() - 1;
        while (i >= 0) {
            ASN1Set rdn = (ASN1Set)this.get(i);
            int n = rdn.size();
            int j = 0;
            while (j < n) {
                AVA entry;
                boolean sibling = j < n - 1;
                ASN1Sequence ava = (ASN1Sequence)rdn.get(j);
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)ava.get(0);
                ASN1Type obj = (ASN1Type)ava.get(1);
                String key = (String)this.oid2a_.get(oid);
                if (key == null) {
                    key = oid.toString();
                }
                if (obj instanceof ASN1String) {
                    String val = ((ASN1String)obj).getString();
                    entry = new AVA(key, val, sibling);
                } else {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        DEREncoder enc = new DEREncoder(out);
                        obj.encode(enc);
                        entry = new AVA(key, out.toByteArray(), sibling);
                        enc.close();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot BER encode!");
                    }
                }
                list.add(entry);
                ++j;
            }
            --i;
        }
        return list;
    }

    public String getReverseName() {
        if (this.rname_ != null) {
            return this.rname_;
        }
        StringBuffer buf = new StringBuffer();
        Iterator i = this.getReverseAVAList().iterator();
        while (i.hasNext()) {
            AVA entry = (AVA)i.next();
            buf.append(entry.getKey());
            buf.append("=");
            if (entry.isEncodedValue()) {
                buf.append("#");
                buf.append(entry.getValue());
            } else {
                buf.append(entry.getValue());
            }
            if (entry.hasSibling()) {
                buf.append(" + ");
                continue;
            }
            buf.append(", ");
        }
        int n = buf.length();
        if (n > 0) {
            buf.setLength(n - 2);
        }
        this.rname_ = buf.toString();
        return this.rname_;
    }

    public ASN1Type resolve(ASN1Type caller) {
        if (caller == null) {
            throw new NullPointerException("caller");
        }
        if (this.tmp_ == null) {
            this.tmp_ = new ArrayList(8);
        }
        ASN1Sequence seq = new ASN1Sequence(2);
        seq.add(new ASN1ObjectIdentifier());
        seq.add(new ASN1OpenType());
        this.tmp_.add(seq);
        return seq;
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        this.clear();
        super.decode(dec);
        Iterator i = this.tmp_.iterator();
        while (i.hasNext()) {
            ASN1Sequence seq = (ASN1Sequence)i.next();
            ASN1OpenType t = (ASN1OpenType)seq.get(1);
            ASN1Type o = t.getInnerType();
            seq.set(1, o);
        }
        this.tmp_ = null;
    }

    public boolean add(ASN1Set o) {
        if (o == null) {
            throw new NullPointerException("parameter is null");
        }
        ASN1Set set = o;
        Iterator it = ((AbstractList)set).iterator();
        while (it.hasNext()) {
            Object p = it.next();
            if (!(p instanceof ASN1Sequence)) {
                throw new IllegalArgumentException("not a sequence: " + p.getClass().getName());
            }
            ASN1Sequence seq = (ASN1Sequence)p;
            if (seq.size() != 2) {
                throw new IllegalArgumentException("sequence does not have 2 elements: " + seq.size());
            }
            if (!(seq.get(0) instanceof ASN1ObjectIdentifier)) {
                throw new IllegalArgumentException("attribute type not an OID");
            }
            p = seq.get(1);
            if (p != null && p instanceof ASN1Type) continue;
            throw new IllegalArgumentException("illegal or no attribute value");
        }
        super.add(set);
        return true;
    }

    public ASN1Type newElement() {
        ASN1SetOf set = new ASN1SetOf(this, 1);
        super.add(set);
        return set;
    }

    public boolean equals(Object o) {
        Name q;
        if (!(o instanceof Principal)) {
            return false;
        }
        if (!(o instanceof Name)) {
            try {
                q = new Name(((Principal)o).getName());
            }
            catch (BadNameException e) {
                return false;
            }
            catch (Exception e) {
                return false;
            }
        } else {
            q = (Name)o;
        }
        Hashtable table1 = this.getNameTable();
        Hashtable table2 = q.getNameTable();
        if (table1.size() != table2.size()) {
            return false;
        }
        Enumeration en = table1.keys();
        while (en.hasMoreElements()) {
            Integer int2;
            String str = (String)en.nextElement();
            if (!table2.containsKey(str)) {
                return false;
            }
            Integer int1 = (Integer)table1.get(str);
            if (int1.compareTo(int2 = (Integer)table2.get(str)) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isPatternMatch(Name name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Iterator i = this.getAVAList().iterator();
        Iterator j = name.getAVAList().iterator();
        while (i.hasNext() && j.hasNext()) {
            AVA ap = (AVA)i.next();
            AVA an = (AVA)j.next();
            String tmp = ap.getKey();
            if (!tmp.equals(an.getKey())) {
                return false;
            }
            if (ap.hasSibling() != an.hasSibling()) {
                return false;
            }
            tmp = ap.getValue();
            if (tmp.equals(MATCH_ALL) || tmp.equalsIgnoreCase(an.getValue())) continue;
            return false;
        }
        return i.hasNext() == j.hasNext();
    }

    public boolean partOf(Name name) {
        if (name == null) {
            return false;
        }
        Hashtable table1 = this.getNameTable();
        Hashtable table2 = name.getNameTable();
        Enumeration e = table1.keys();
        while (e.hasMoreElements()) {
            Integer ord2;
            String str = (String)e.nextElement();
            if (!table2.containsKey(str)) {
                return false;
            }
            Integer ord1 = (Integer)table1.get(str);
            if (ord1.compareTo(ord2 = (Integer)table2.get(str)) == 0) continue;
            return false;
        }
        return true;
    }

    public static Name clone(Name source) throws IllegalArgumentException {
        Name result = null;
        if (source == null || source.getName().length() == 0) {
            throw new IllegalArgumentException("Name/Principal must not be null nor empty !");
        }
        Name seq = source;
        Vector sets = new Vector();
        int i = 0;
        while (i < seq.size()) {
            sets.add(seq.get(i));
            ++i;
        }
        result = new Name();
        int j = 0;
        while (j < sets.size()) {
            result.add((ASN1Set)sets.elementAt(j));
            ++j;
        }
        return result;
    }

    public static Name clone(Principal sourcePrincipal) throws BadNameException, IllegalArgumentException {
        if (sourcePrincipal == null || sourcePrincipal.getName().length() == 0) {
            throw new IllegalArgumentException("Name/Principal must not be null nor empty !");
        }
        return new Name(sourcePrincipal.getName(), defaultEncoding_);
    }

    public Hashtable divide() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        List list = this.getAVAList();
        int iou = 0;
        int i = 0;
        while (i < list.size()) {
            AVA ava = (AVA)list.get(i);
            if ("1.2.840.113549.1.9.2".equals(ava.getKey())) {
                result.put("UN", ava.getValue());
                StringTokenizer st = new StringTokenizer(ava.getValue(), ".");
                int j = 0;
                while (st.hasMoreTokens()) {
                    result.put("UN" + ++j, st.nextToken());
                }
            } else if ("1.2.840.113549.1.9.8".equals(ava.getKey())) {
                result.put("UA", ava.getValue());
            } else if ("OU".equals(ava.getKey())) {
                if (result.get("OU") == null) {
                    result.put("OU", ava.getValue());
                } else {
                    result.put("OU0", (String)result.get("OU"));
                    result.put("OU" + ++iou, ava.getValue());
                }
            } else {
                result.put(ava.getKey(), ava.getValue());
            }
            ++i;
        }
        return result;
    }

    protected Hashtable getNameTable() {
        int order = 1;
        Hashtable<String, Integer> nameTable = new Hashtable<String, Integer>();
        Iterator it = this.getAVAList().iterator();
        while (it.hasNext()) {
            AVA entry = (AVA)it.next();
            String key = entry.toString();
            int i = 1;
            while (nameTable.containsKey(key)) {
                key = new AVA(entry.getKey() + i, entry.getValue(), entry.hasSibling()).toString();
                ++i;
            }
            nameTable.put(key, new Integer(order));
            if (entry.hasSibling()) continue;
            ++order;
        }
        return nameTable;
    }
}

