/*
 * Decompiled with CFR 0.152.
 */
package codec.pkcs7;

import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Type;
import codec.asn1.DEREncoder;
import codec.pkcs7.Data;
import codec.pkcs7.Signable;
import codec.pkcs7.SignedAndEnvelopedData;
import codec.pkcs7.SignerInfo;
import codec.pkcs9.Attributes;
import codec.pkcs9.InvalidAttributeException;
import codec.util.JCA;
import codec.x501.Attribute;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class Signer {
    private ASN1ObjectIdentifier MESSAGE_DIGEST = new ASN1ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 9, 4});
    private ASN1ObjectIdentifier CONTENT_TYPE = new ASN1ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 9, 3});
    public static final int BUFFER_SIZE = 1024;
    protected Signable target_;
    private Signature sig_;
    protected SignerInfo info_;
    protected MessageDigest digest_;
    protected ASN1ObjectIdentifier contentType_;
    protected boolean twostep_ = false;
    private boolean strict = false;

    public Signer(Signable sigdat, SignerInfo info, PrivateKey key) throws GeneralSecurityException {
        if (sigdat == null || info == null || key == null) {
            throw new NullPointerException("Need a Signable, SignerInfo and PrivateKey!");
        }
        this.info_ = info;
        this.target_ = sigdat;
        String sigalg = this.info_.getAlgorithm();
        Attributes attributes = this.info_.authenticatedAttributes();
        ASN1ObjectIdentifier oid = this.target_.getContentType();
        if (attributes.size() > 0) {
            this.twostep_ = true;
            Attribute attribute = this.info_.authenticatedAttributes().getAttribute(this.CONTENT_TYPE);
            if (attribute == null) {
                attribute = new Attribute((ASN1ObjectIdentifier)this.CONTENT_TYPE.clone(), (ASN1ObjectIdentifier)oid.clone());
                attributes.add(attribute);
            } else {
                if (attribute.valueCount() < 1) {
                    throw new InvalidAttributeException("Content type attribute has no value!");
                }
                if (!attribute.valueAt(0).equals(oid)) {
                    throw new InvalidAttributeException("Content type attribute has wrong value!");
                }
            }
            attribute = this.info_.authenticatedAttributes().getAttribute(this.MESSAGE_DIGEST);
            if (attribute != null) {
                throw new IllegalArgumentException("Message digest attribute already exists!");
            }
            String mdalg = JCA.getName(JCA.getDigestOID(sigalg));
            if (mdalg == null) {
                throw new NoSuchAlgorithmException("Cannot determine digest algorithm for " + sigalg);
            }
            this.digest_ = MessageDigest.getInstance(mdalg);
        }
        this.sig_ = Signature.getInstance(sigalg);
        AlgorithmParameterSpec spec = this.info_.getParameterSpec();
        if (spec != null) {
            this.sig_.setParameter(spec);
        }
        this.sig_.initSign(key);
    }

    public void setStrict(boolean strictness) {
        this.strict = strictness;
    }

    /*
     * WARNING - void declaration
     */
    public void update(InputStream in) throws SignatureException, IOException {
        byte[] buf = new byte[1024];
        try {
            int n;
            while ((n = in.read(buf)) > 0) {
                void var3_3;
                this.update(buf, 0, (int)var3_3);
            }
        }
        catch (IOException e) {
            this.reset();
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update() throws GeneralSecurityException {
        ASN1Type t = this.target_.getContent();
        if (t == null) {
            return;
        }
        if (t instanceof Data) {
            this.update(((Data)t).getByteArray());
            return;
        }
        boolean tagging = t.isExplicit();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEREncoder enc = new DEREncoder(bos);
        if (this.strict) {
            enc.setStrict(true);
        }
        try {
            try {
                t.setExplicit(false);
                enc.writeType(t);
                this.update(bos.toByteArray());
            }
            catch (Exception e) {
                throw new SignatureException("Exception while re-encoding!");
            }
            Object var7_5 = null;
            t.setExplicit(tagging);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            t.setExplicit(tagging);
            try {
                enc.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        enc.close();
        return;
    }

    public void update(byte[] b) throws SignatureException {
        this.update(b, 0, b.length);
    }

    public void update(byte[] b, int offset, int len) throws SignatureException {
        try {
            if (this.twostep_) {
                this.digest_.update(b, offset, len);
            } else {
                this.sig_.update(b, offset, len);
            }
        }
        catch (SignatureException e) {
            this.reset();
            throw e;
        }
    }

    private void reset() {
        this.sig_ = null;
        this.info_ = null;
        this.digest_ = null;
        this.target_ = null;
    }

    public void sign() throws GeneralSecurityException {
        if (this.twostep_) {
            byte[] b = this.digest_.digest();
            Attribute attribute = new Attribute((ASN1ObjectIdentifier)this.MESSAGE_DIGEST.clone(), new ASN1OctetString(b));
            this.info_.addAuthenticatedAttribute(attribute);
            this.info_.update(this.sig_);
        }
        if (this.target_ instanceof SignedAndEnvelopedData) {
            SignedAndEnvelopedData saed = (SignedAndEnvelopedData)this.target_;
            byte[] edig = saed.encryptBulkData(this.sig_.sign());
            this.info_.setEncryptedDigest(edig);
        } else {
            this.info_.setEncryptedDigest(this.sig_.sign());
        }
        this.target_.addSignerInfo(this.info_);
    }
}

