/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Type;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ASN1Opaque
extends ASN1TaggedType {
    public ASN1Opaque() {
        super(-1, 0, new ASN1OctetString(), false);
    }

    public ASN1Opaque(byte[] code) throws ASN1Exception {
        super(-1, 0, new ASN1OctetString(), false);
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(code);
            DERDecoder dec = new DERDecoder(bis);
            this.decode(dec);
            dec.close();
        }
        catch (IOException e) {
            throw new ASN1Exception("Internal, caught IOException!");
        }
    }

    public ASN1Opaque(int tag, int tagclass, byte[] b) {
        super(tag, tagclass, new ASN1OctetString((byte[])b.clone()), false);
    }

    public boolean isType(int tag, int tagclass) {
        if (tagclass != 0) {
            return false;
        }
        if (this.getTag() == -1) {
            this.setTag(tag);
            return true;
        }
        return super.isType(tag, tagclass);
    }

    public byte[] getEncoded() throws ASN1Exception {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DEREncoder enc = new DEREncoder(bos);
            this.encode(enc);
            byte[] code = bos.toByteArray();
            enc.close();
            return code;
        }
        catch (IOException e) {
            throw new ASN1Exception("Internal, caught IOException!");
        }
    }

    public void setInnerType(ASN1Type t) {
        super.setInnerType(t);
    }

    public Object clone() {
        ASN1Opaque o;
        try {
            o = (ASN1Opaque)super.clone();
            ASN1OctetString b = (ASN1OctetString)o.getInnerType();
            o.setInnerType((ASN1OctetString)b.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Internal, clone support mismatch!");
        }
        return o;
    }
}

