/*
 * Decompiled with CFR 0.152.
 */
package codec;

import codec.CorruptedCodeException;

public final class Base64 {
    private static final char[] BASE64 = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/").toCharArray();
    private static final char PAD_1 = '=';
    private static final String PAD_2 = "==";
    private static final byte F = -1;
    private static final byte PAD = 64;
    private static final byte[] REVERSE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 64, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    private static final String HEX = "0123456789abcdef";

    private Base64() {
    }

    public static String encode(byte[] input) {
        int m;
        byte b;
        byte a;
        if (input.length == 0) {
            return "";
        }
        int i = (input.length + 2) / 3 << 2;
        StringBuffer output = new StringBuffer(i);
        i = input.length / 3;
        int j = 0;
        while (i > 0) {
            a = input[j++];
            b = input[j++];
            byte c = input[j++];
            m = a >>> 2 & 0x3F;
            output.append(BASE64[m]);
            m = (a & 3) << 4 | b >>> 4 & 0xF;
            output.append(BASE64[m]);
            m = (b & 0xF) << 2 | c >>> 6 & 3;
            output.append(BASE64[m]);
            m = c & 0x3F;
            output.append(BASE64[m]);
            --i;
        }
        i = input.length % 3;
        switch (i) {
            case 1: {
                a = input[j++];
                m = a >>> 2 & 0x3F;
                output.append(BASE64[m]);
                m = (a & 3) << 4;
                output.append(BASE64[m]);
                output.append(PAD_2);
                break;
            }
            case 2: {
                a = input[j++];
                b = input[j++];
                m = a >>> 2 & 0x3F;
                output.append(BASE64[m]);
                m = (a & 3) << 4 | b >>> 4 & 0xF;
                output.append(BASE64[m]);
                m = (b & 0xF) << 2;
                output.append(BASE64[m]);
                output.append('=');
            }
        }
        return output.toString();
    }

    public static byte[] decode(String input) throws CorruptedCodeException {
        if (input.length() == 0) {
            return new byte[0];
        }
        byte[] b = new byte[input.length()];
        int i = input.length() - 1;
        while (i >= 0) {
            b[i] = (byte)input.charAt(i);
            --i;
        }
        return Base64.decode(b);
    }

    public static byte[] decode(byte[] code) throws CorruptedCodeException {
        byte c;
        byte a;
        int l = code.length;
        boolean end = false;
        int i = 0;
        int j = 0;
        while (i < l) {
            if (code[i] < 0 || code[i] >= REVERSE.length) {
                throw new CorruptedCodeException("Code was not Base64 encoded");
            }
            byte m = REVERSE[code[i]];
            if (m == 64) {
                if (end) break;
                end = true;
            } else {
                if (end) {
                    throw new CorruptedCodeException("Second pad character missing!");
                }
                if (m != -1) {
                    code[j++] = m;
                }
            }
            ++i;
        }
        l = j >> 2;
        i = l * 3;
        int k = j & 3;
        if (k == 1) {
            throw new CorruptedCodeException("One character is missing!");
        }
        if (k > 0) {
            i = i + k - 1;
        }
        byte[] output = new byte[i];
        i = 0;
        j = 0;
        byte b = 0;
        while (l > 0) {
            a = code[i++];
            b = code[i++];
            c = code[i++];
            byte d = code[i++];
            output[j++] = (byte)(a << 2 | b >>> 4 & 3);
            output[j++] = (byte)((b & 0xF) << 4 | c >>> 2 & 0xF);
            output[j++] = (byte)((c & 3) << 6 | d);
            --l;
        }
        if (k >= 2) {
            a = code[i++];
            b = code[i++];
            output[j++] = (byte)(a << 2 | b >>> 4 & 3);
        }
        if (k >= 3) {
            c = code[i++];
            output[j++] = (byte)((b & 0xF) << 4 | c >>> 2 & 0xF);
        }
        return output;
    }

    public static String toHex(byte[] b) {
        StringBuffer buf = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            buf.append(HEX.charAt(b[i] >> 4 & 0xF));
            buf.append(HEX.charAt(b[i] & 0xF));
            ++i;
        }
        return buf.toString();
    }
}

