/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.rsa.RSAPublicKeySpec;

public final class RSAPublicKey
extends de.flexiprovider.core.rsa.interfaces.RSAPublicKey {
    private FlexiBigInt n;
    private FlexiBigInt e;

    public RSAPublicKey(FlexiBigInt n, FlexiBigInt e) {
        this.n = n;
        this.e = e;
    }

    public RSAPublicKey(RSAPublicKeySpec keySpec) {
        this(keySpec.getN(), keySpec.getE());
    }

    public FlexiBigInt getN() {
        return this.n;
    }

    public FlexiBigInt getE() {
        return this.e;
    }

    public String toString() {
        String result = "modulus n = 0x" + this.n.toString(16) + "\n";
        result = result + "public exponent e = 0x" + this.e.toString(16);
        return result;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RSAPublicKey)) {
            return false;
        }
        RSAPublicKey otherKey = (RSAPublicKey)other;
        return this.n.equals(otherKey.n) && this.e.equals(otherKey.e);
    }

    public int hashCode() {
        return this.n.hashCode() + this.e.hashCode();
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier("1.2.840.113549.1.1.1");
    }

    protected ASN1Type getAlgParams() {
        return new ASN1Null();
    }

    protected byte[] getKeyData() {
        ASN1Sequence keyData = new ASN1Sequence();
        keyData.add(ASN1Tools.createInteger(this.n));
        keyData.add(ASN1Tools.createInteger(this.e));
        return ASN1Tools.derEncode((ASN1Type)keyData);
    }
}

