/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.rsa.RSAPrivateCrtKeySpec;

public class RSAPrivateCrtKey
extends de.flexiprovider.core.rsa.interfaces.RSAPrivateCrtKey {
    private static final String RSA_OID_STRING = "1.2.840.113549.1.1.1";
    protected FlexiBigInt n;
    protected FlexiBigInt d;
    protected FlexiBigInt e;
    protected FlexiBigInt p;
    protected FlexiBigInt q;
    protected FlexiBigInt dP;
    protected FlexiBigInt dQ;
    protected FlexiBigInt crtCoeff;

    public RSAPrivateCrtKey(FlexiBigInt n, FlexiBigInt e, FlexiBigInt d, FlexiBigInt p, FlexiBigInt q, FlexiBigInt dP, FlexiBigInt dQ, FlexiBigInt crtCoeff) {
        this.n = n;
        this.d = d;
        this.e = e;
        this.p = p;
        this.q = q;
        this.dP = dP;
        this.dQ = dQ;
        this.crtCoeff = crtCoeff;
    }

    protected RSAPrivateCrtKey(RSAPrivateCrtKeySpec keySpec) {
        this(keySpec.getN(), keySpec.getE(), keySpec.getD(), keySpec.getP(), keySpec.getQ(), keySpec.getDp(), keySpec.getDq(), keySpec.getCRTCoeff());
    }

    public FlexiBigInt getN() {
        return this.n;
    }

    public FlexiBigInt getE() {
        return this.e;
    }

    public FlexiBigInt getD() {
        return this.d;
    }

    public FlexiBigInt getP() {
        return this.p;
    }

    public FlexiBigInt getQ() {
        return this.q;
    }

    public FlexiBigInt getDp() {
        return this.dP;
    }

    public FlexiBigInt getDq() {
        return this.dQ;
    }

    public FlexiBigInt getCRTCoeff() {
        return this.crtCoeff;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RSAPrivateCrtKey)) {
            return false;
        }
        RSAPrivateCrtKey otherKey = (RSAPrivateCrtKey)other;
        return this.n.equals(otherKey.n) && this.p.equals(otherKey.p) && this.q.equals(otherKey.q) && this.d.equals(otherKey.d) && this.e.equals(otherKey.e) && this.dP.equals(otherKey.dP) && this.dQ.equals(otherKey.dQ) && this.crtCoeff.equals(otherKey.crtCoeff);
    }

    public String toString() {
        String out = "";
        out = out + "modulus n:          0x" + this.n.toString(16) + "\n";
        out = out + "public exponent e:  0x" + this.e.toString(16) + "\n";
        out = out + "private exponent d: 0x" + this.d.toString(16) + "\n";
        out = out + "prime P:            0x" + this.p.toString(16) + "\n";
        out = out + "prime Q:            0x" + this.q.toString(16) + "\n";
        out = out + "prime exponent P:   0x" + this.dP.toString(16) + "\n";
        out = out + "prime exponent Q:   0x" + this.dQ.toString(16) + "\n";
        out = out + "crt coefficient:    0x" + this.crtCoeff.toString(16) + "\n";
        return out;
    }

    public int hashCode() {
        return this.n.hashCode() + this.d.hashCode() + this.e.hashCode() + this.p.hashCode() + this.q.hashCode() + this.dP.hashCode() + this.dQ.hashCode() + this.crtCoeff.hashCode();
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier(RSA_OID_STRING);
    }

    protected ASN1Type getAlgParams() {
        return new ASN1Null();
    }

    protected byte[] getKeyData() {
        ASN1Sequence keyData = new ASN1Sequence();
        keyData.add(new ASN1Integer(0));
        keyData.add(ASN1Tools.createInteger(this.n));
        keyData.add(ASN1Tools.createInteger(this.e));
        keyData.add(ASN1Tools.createInteger(this.d));
        keyData.add(ASN1Tools.createInteger(this.p));
        keyData.add(ASN1Tools.createInteger(this.q));
        keyData.add(ASN1Tools.createInteger(this.dP));
        keyData.add(ASN1Tools.createInteger(this.dQ));
        keyData.add(ASN1Tools.createInteger(this.crtCoeff));
        return ASN1Tools.derEncode((ASN1Type)keyData);
    }
}

