/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rsa;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.rsa.PSSParameterSpec;
import de.flexiprovider.pki.AlgorithmIdentifier;
import java.io.IOException;

public class PSSParameters
extends AlgorithmParameters {
    private String md;
    private int saltLength;
    static /* synthetic */ Class class$de$flexiprovider$core$rsa$PSSParameterSpec;

    public void init(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null || !(paramSpec instanceof PSSParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        PSSParameterSpec pssParams = (PSSParameterSpec)paramSpec;
        this.md = pssParams.getMD();
        this.saltLength = pssParams.getSaltLength();
    }

    public void init(byte[] encParams) throws IOException {
        ASN1Sequence asn1Params = new ASN1Sequence(3);
        asn1Params.add(new AlgorithmIdentifier());
        asn1Params.add(new AlgorithmIdentifier());
        asn1Params.add(new ASN1Integer());
        asn1Params.add(new ASN1Integer());
        try {
            ASN1Tools.derDecode(encParams, (ASN1Type)asn1Params);
        }
        catch (ASN1Exception e) {
            throw new IOException("ASN1Exception: " + e.getMessage());
        }
        String mgf = ((AlgorithmIdentifier)((Object)asn1Params.get(1))).getAlgorithmOID().toString();
        if (!mgf.equals("1.2.840.113549.1.1.8")) {
            throw new IOException("unsupported parameters");
        }
        int trailerField = ASN1Tools.getFlexiBigInt((ASN1Integer)asn1Params.get(3)).intValue();
        if (trailerField != 1) {
            throw new IOException("unsupported parameters");
        }
        this.md = ((AlgorithmIdentifier)((Object)asn1Params.get(0))).getAlgorithmOID().toString();
        this.saltLength = ASN1Tools.getFlexiBigInt((ASN1Integer)asn1Params.get(2)).intValue();
    }

    public void init(byte[] encParams, String format) throws IOException {
        if (format == null || !format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        this.init(encParams);
    }

    public byte[] getEncoded() throws IOException {
        ASN1Sequence asn1Params = new ASN1Sequence(3);
        try {
            AlgorithmIdentifier mdIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(this.md), (ASN1Type)new ASN1Null());
            asn1Params.add(mdIdentifier);
            AlgorithmIdentifier mgfIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.8"), (ASN1Type)mdIdentifier);
            asn1Params.add(mgfIdentifier);
        }
        catch (ASN1Exception e) {
            throw new IOException("ASN1Exception: " + e.getMessage());
        }
        asn1Params.add(new ASN1Integer(this.saltLength));
        asn1Params.add(new ASN1Integer(1));
        return ASN1Tools.derEncode((ASN1Type)asn1Params);
    }

    public byte[] getEncoded(String format) throws IOException {
        if (format == null || !format.equals("ASN.1")) {
            throw new IOException("unsupported format");
        }
        return this.getEncoded();
    }

    public AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null || !paramSpec.isAssignableFrom(class$de$flexiprovider$core$rsa$PSSParameterSpec == null ? (class$de$flexiprovider$core$rsa$PSSParameterSpec = PSSParameters.class$("de.flexiprovider.core.rsa.PSSParameterSpec")) : class$de$flexiprovider$core$rsa$PSSParameterSpec)) {
            throw new InvalidParameterSpecException("unsupported type");
        }
        return new PSSParameterSpec(this.md, this.saltLength);
    }

    public String toString() {
        String result = "PSS parameters:\n";
        result = result + "MD OID       : " + this.md + "\n";
        result = result + "MGF OID      : 1.2.840.113549.1.1.8\n";
        result = result + "salt length  : " + this.saltLength + "\n";
        result = result + "trailer field: 1\n";
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

