/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rc6;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.rc6.RC6Key;
import de.flexiprovider.core.rc6.RC6KeyGenParameterSpec;

public class RC6KeyGenerator
extends SecretKeyGenerator {
    private int keySize;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        RC6KeyGenParameterSpec rc6Params;
        if (params == null) {
            rc6Params = new RC6KeyGenParameterSpec();
        } else if (params instanceof RC6KeyGenParameterSpec) {
            rc6Params = (RC6KeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = rc6Params.getKeySize() >> 3;
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int keySize, SecureRandom random) {
        RC6KeyGenParameterSpec params = new RC6KeyGenParameterSpec(keySize);
        try {
            this.init(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public void init(SecureRandom random) {
        RC6KeyGenParameterSpec defaultParams = new RC6KeyGenParameterSpec();
        try {
            this.init(defaultParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] keyBytes = new byte[this.keySize];
        this.random.nextBytes(keyBytes);
        return new RC6Key(keyBytes);
    }
}

