/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rc6;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.LittleEndianConversions;
import de.flexiprovider.core.rc6.RC6Key;

public class RC6
extends BlockCipher {
    public static final String ALG_NAME = "RC6";
    private int[] S;
    private static final int blockSize = 16;
    private static final int rounds = 20;
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;

    public String getName() {
        return ALG_NAME;
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof RC6Key) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("Not a RC6 Key");
        }
        int keyLen = key.getEncoded().length;
        keyLen -= keyLen & 3;
        return keyLen << 3;
    }

    public int getCipherBlockSize() {
        return 16;
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (!(key instanceof RC6Key)) {
            throw new InvalidKeyException("not a RC6 Key");
        }
        this.keySchedule(key.getEncoded());
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.initCipherEncrypt(key, params);
    }

    private void keySchedule(byte[] key) {
        int c = (key.length << 3) + 31 >> 5;
        int[] L = new int[c];
        int i = 0;
        while (i < key.length >> 2) {
            int j = 0;
            while (j < 4) {
                int swp = key[(i << 2) + j] & 0xFF;
                int n = i;
                L[n] = L[n] + (swp << (j << 3));
                ++j;
            }
            ++i;
        }
        this.S = new int[44];
        this.S[0] = -1209970333;
        int i2 = 1;
        while (i2 <= 43) {
            this.S[i2] = this.S[i2 - 1] + -1640531527;
            ++i2;
        }
        int A = 0;
        int B = 0;
        int i3 = 0;
        int j = 0;
        int v = 3 * Math.max(c, 44);
        int s = 1;
        while (s <= v) {
            this.S[i3] = RC6.leftRotate(this.S[i3] + A + B, 3);
            A = this.S[i3];
            L[j] = RC6.leftRotate(L[j] + A + B, A + B & 0x1F);
            B = L[j];
            i3 = (i3 + 1) % 44;
            j = (j + 1) % c;
            ++s;
        }
    }

    protected void singleBlockEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        int A = LittleEndianConversions.OS2IP(input, inOff);
        int B = LittleEndianConversions.OS2IP(input, inOff + 4);
        int C = LittleEndianConversions.OS2IP(input, inOff + 8);
        int D = LittleEndianConversions.OS2IP(input, inOff + 12);
        B += this.S[0];
        D += this.S[1];
        int i = 1;
        while (i <= 20) {
            int t = (B << 1) + 1;
            t *= B;
            t = RC6.leftRotateBy5(t);
            int u = (D << 1) + 1;
            u *= D;
            u = RC6.leftRotateBy5(u);
            A = RC6.leftRotate(A ^ t, u & 0x1F) + this.S[i << 1];
            C = RC6.leftRotate(C ^ u, t & 0x1F) + this.S[(i << 1) + 1];
            int swp = A;
            A = B;
            B = C;
            C = D;
            D = swp;
            ++i;
        }
        LittleEndianConversions.I2OSP(A += this.S[42], output, outOff);
        LittleEndianConversions.I2OSP(B, output, outOff + 4);
        LittleEndianConversions.I2OSP(C += this.S[43], output, outOff + 8);
        LittleEndianConversions.I2OSP(D, output, outOff + 12);
    }

    protected void singleBlockDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        int A = LittleEndianConversions.OS2IP(input, inOff);
        int B = LittleEndianConversions.OS2IP(input, inOff + 4);
        int C = LittleEndianConversions.OS2IP(input, inOff + 8);
        int D = LittleEndianConversions.OS2IP(input, inOff + 12);
        C -= this.S[43];
        A -= this.S[42];
        int i = 20;
        while (i >= 1) {
            int swp = A;
            A = D;
            D = C;
            C = B;
            B = swp;
            int u = (D << 1) + 1;
            u *= D;
            u = RC6.leftRotateBy5(u);
            int t = (B << 1) + 1;
            t *= B;
            t = RC6.leftRotateBy5(t);
            C -= this.S[(i << 1) + 1];
            C = RC6.rightRotate(C, t & 0x1F) ^ u;
            A -= this.S[i << 1];
            A = RC6.rightRotate(A, u & 0x1F) ^ t;
            --i;
        }
        LittleEndianConversions.I2OSP(A, output, outOff);
        LittleEndianConversions.I2OSP(B -= this.S[0], output, outOff + 4);
        LittleEndianConversions.I2OSP(C, output, outOff + 8);
        LittleEndianConversions.I2OSP(D -= this.S[1], output, outOff + 12);
    }

    private static int rightRotate(int data, int n) {
        return data >>> n | data << 32 - n;
    }

    private static int leftRotate(int data, int n) {
        return data << n | data >>> 32 - n;
    }

    private static int leftRotateBy5(int data) {
        return data << 5 | data >>> 27;
    }
}

