/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rc2;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.rc2.RC2Key;
import de.flexiprovider.core.rc2.RC2KeyGenParameterSpec;

public class RC2KeyGenerator
extends de.flexiprovider.core.rc2.interfaces.RC2KeyGenerator {
    private int keySize;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        RC2KeyGenParameterSpec rc2Params;
        if (params == null) {
            rc2Params = new RC2KeyGenParameterSpec();
        } else if (params instanceof RC2KeyGenParameterSpec) {
            rc2Params = (RC2KeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = rc2Params.getKeySize();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void init(int keySize, SecureRandom random) {
        RC2KeyGenParameterSpec params = new RC2KeyGenParameterSpec(keySize);
        try {
            this.init(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public void init(SecureRandom random) {
        RC2KeyGenParameterSpec defaultParams = new RC2KeyGenParameterSpec();
        try {
            this.init(defaultParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        int byteSize = this.keySize + 7 >> 3;
        byte[] keyBytes = new byte[byteSize];
        this.random.nextBytes(keyBytes);
        int n = byteSize - 1;
        keyBytes[n] = (byte)(keyBytes[n] & (1 << (this.keySize & 7)) - 1);
        return new RC2Key(keyBytes);
    }
}

