/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.pbe;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.Cipher;
import de.flexiprovider.api.KeyDerivation;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.BadPaddingException;
import de.flexiprovider.api.exceptions.IllegalBlockSizeException;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.exceptions.InvalidParameterSpecException;
import de.flexiprovider.api.exceptions.NoSuchAlgorithmException;
import de.flexiprovider.api.exceptions.NoSuchModeException;
import de.flexiprovider.api.exceptions.NoSuchPaddingException;
import de.flexiprovider.api.exceptions.ShortBufferException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyFactory;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import de.flexiprovider.core.kdf.PBKDF2;
import de.flexiprovider.core.kdf.PBKDF2ParameterSpec;
import de.flexiprovider.core.pbe.PBEKey;
import de.flexiprovider.core.pbe.PBES2ParameterSpec;
import de.flexiprovider.pki.AlgorithmIdentifier;

public class PBES2
extends Cipher {
    public static final String OID = "1.2.840.113549.1.5.13";
    private BlockCipher cipher;
    private KeyDerivation kdf;
    static /* synthetic */ Class class$de$flexiprovider$core$kdf$PBKDF2ParameterSpec;

    public String getName() {
        return "PBES2";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        return key.getEncoded().length << 3;
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public byte[] getIV() {
        return this.cipher.getIV();
    }

    public int getOutputSize(int inputLen) {
        return this.cipher.getOutputSize(inputLen);
    }

    public AlgorithmParameterSpec getParameters() {
        return this.cipher.getParameters();
    }

    public void initEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBKDF2ParameterSpec kdfParams;
        String expKDF2OID;
        if (!(params instanceof PBES2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        PBES2ParameterSpec pbe2Params = (PBES2ParameterSpec)params;
        AlgorithmIdentifier kdfAid = pbe2Params.getKeyDerivationFunction();
        String kdfOID = kdfAid.getAlgorithmOID().toString();
        if (!kdfOID.equals(expKDF2OID = "1.2.840.113549.1.5.12")) {
            throw new InvalidAlgorithmParameterException("unsupported key derivation function");
        }
        try {
            AlgorithmParameters algKdfParams = kdfAid.getParams();
            kdfParams = (PBKDF2ParameterSpec)algKdfParams.getParameterSpec(class$de$flexiprovider$core$kdf$PBKDF2ParameterSpec == null ? (class$de$flexiprovider$core$kdf$PBKDF2ParameterSpec = PBES2.class$("de.flexiprovider.core.kdf.PBKDF2ParameterSpec")) : class$de$flexiprovider$core$kdf$PBKDF2ParameterSpec);
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException("InvalidParameterSpecException: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmParameterException("NoSuchAlgorithmException: " + e.getMessage());
        }
        this.kdf = new PBKDF2();
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("unsupported key type");
        }
        this.kdf.init(key.getEncoded(), kdfParams);
        byte[] uKeyBytes = this.kdf.deriveKey(kdfParams.getKeySize());
        AlgorithmIdentifier cipherAid = pbe2Params.getEncryptionScheme();
        String cipherOID = cipherAid.getAlgorithmOID().toString();
        SecretKey uKey = null;
        try {
            SecretKeySpec uKeySpec = new SecretKeySpec(uKeyBytes, cipherOID);
            SecretKeyFactory skf = Registry.getSecretKeyFactory(cipherOID);
            uKey = skf.generateSecret(uKeySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidAlgorithmParameterException(nsae.getMessage());
        }
        catch (InvalidKeySpecException ikse) {
            throw new InvalidAlgorithmParameterException(ikse.getMessage());
        }
        AlgorithmParameterSpec paramSpec = null;
        try {
            AlgorithmParameters cipherap = cipherAid.getParams();
            Class paramSpecClass = Registry.getAlgParamSpecClass(cipherOID);
            paramSpec = cipherap.getParameterSpec(paramSpecClass);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException(e.getMessage());
        }
        try {
            this.cipher = Registry.getBlockCipher(cipherOID);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidAlgorithmParameterException("did not find block cipher '" + nsae.getMessage() + "'");
        }
        catch (NoSuchPaddingException nspe) {
            throw new InvalidAlgorithmParameterException("NoSuchPaddingException: " + nspe.getMessage());
        }
        this.cipher.initEncrypt(uKey, paramSpec, random);
    }

    public void initDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBKDF2ParameterSpec kdfParams;
        String expKDF2OID;
        if (!(params instanceof PBES2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        PBES2ParameterSpec pbe2Params = (PBES2ParameterSpec)params;
        AlgorithmIdentifier kdfAid = pbe2Params.getKeyDerivationFunction();
        String kdfOID = kdfAid.getAlgorithmOID().toString();
        if (!kdfOID.equals(expKDF2OID = "1.2.840.113549.1.5.12")) {
            throw new InvalidAlgorithmParameterException("unsupported key derivation function");
        }
        try {
            AlgorithmParameters algKdfParams = kdfAid.getParams();
            kdfParams = (PBKDF2ParameterSpec)algKdfParams.getParameterSpec(class$de$flexiprovider$core$kdf$PBKDF2ParameterSpec == null ? (class$de$flexiprovider$core$kdf$PBKDF2ParameterSpec = PBES2.class$("de.flexiprovider.core.kdf.PBKDF2ParameterSpec")) : class$de$flexiprovider$core$kdf$PBKDF2ParameterSpec);
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException("InvalidParameterSpecException: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmParameterException("NoSuchAlgorithmException: " + e.getMessage());
        }
        this.kdf = new PBKDF2();
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("unsupported key type");
        }
        this.kdf.init(key.getEncoded(), kdfParams);
        byte[] uKeyBytes = this.kdf.deriveKey(kdfParams.getKeySize());
        AlgorithmIdentifier cipherAid = pbe2Params.getEncryptionScheme();
        String cipherOID = cipherAid.getAlgorithmOID().toString();
        SecretKey uKey = null;
        try {
            SecretKeySpec uKeySpec = new SecretKeySpec(uKeyBytes, cipherOID);
            SecretKeyFactory skf = Registry.getSecretKeyFactory(cipherOID);
            uKey = skf.generateSecret(uKeySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidAlgorithmParameterException(nsae.getMessage());
        }
        catch (InvalidKeySpecException ikse) {
            throw new InvalidAlgorithmParameterException(ikse.getMessage());
        }
        AlgorithmParameterSpec paramSpec = null;
        try {
            AlgorithmParameters cipherap = cipherAid.getParams();
            Class paramSpecClass = Registry.getAlgParamSpecClass(cipherOID);
            paramSpec = cipherap.getParameterSpec(paramSpecClass);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException(e.getMessage());
        }
        try {
            this.cipher = Registry.getBlockCipher(cipherOID);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidAlgorithmParameterException("did not find block cipher '" + nsae.getMessage() + "'");
        }
        catch (NoSuchPaddingException nspe) {
            throw new InvalidAlgorithmParameterException("NoSuchPaddingException: " + nspe.getMessage());
        }
        this.cipher.initDecrypt(uKey, paramSpec);
    }

    protected void setMode(String modeName) throws NoSuchModeException {
        throw new NoSuchModeException("unsupported");
    }

    protected void setPadding(String paddingName) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("not supported");
    }

    public byte[] update(byte[] input, int inOff, int inLen) {
        return this.cipher.update(input, inOff, inLen);
    }

    public int update(byte[] input, int inOff, int inLen, byte[] output, int outOff) throws ShortBufferException {
        return this.cipher.update(input, inOff, inLen, output, outOff);
    }

    public byte[] doFinal(byte[] input, int inOff, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inOff, inLen);
    }

    public int doFinal(byte[] input, int inOff, int inLen, byte[] output, int outOff) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inOff, inLen, output, outOff);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

