/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mprsa;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.core.mprsa.MpRSAPrivateKeySpec;
import de.flexiprovider.core.mprsa.RSAOtherPrimeInfo;
import de.flexiprovider.core.rsa.RSAPrivateCrtKey;

public class MpRSAPrivateKey
extends RSAPrivateCrtKey {
    private RSAOtherPrimeInfo[] otherPrimeInfo;

    public MpRSAPrivateKey(FlexiBigInt n, FlexiBigInt e, FlexiBigInt d, FlexiBigInt p, FlexiBigInt q, FlexiBigInt dP, FlexiBigInt dQ, FlexiBigInt crtCoeff, RSAOtherPrimeInfo[] otherPrimeInfo) {
        super(n, d, e, p, q, dP, dQ, crtCoeff);
        this.otherPrimeInfo = otherPrimeInfo;
    }

    protected MpRSAPrivateKey(MpRSAPrivateKeySpec keySpec) {
        this(keySpec.getN(), keySpec.getE(), keySpec.getD(), keySpec.getP(), keySpec.getQ(), keySpec.getDp(), keySpec.getDq(), keySpec.getCRTCoeff(), keySpec.getOtherPrimeInfo());
    }

    public RSAOtherPrimeInfo[] getOtherPrimeInfo() {
        return this.otherPrimeInfo;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof MpRSAPrivateKey)) {
            return false;
        }
        MpRSAPrivateKey otherKey = (MpRSAPrivateKey)other;
        if (this.n.equals(otherKey.n) && this.p.equals(otherKey.p) && this.q.equals(otherKey.q) && this.d.equals(otherKey.d) && this.e.equals(otherKey.e) && this.dP.equals(otherKey.dP) && this.dQ.equals(otherKey.dQ) && this.crtCoeff.equals(otherKey.crtCoeff)) {
            RSAOtherPrimeInfo[] otherP = otherKey.getOtherPrimeInfo();
            boolean b = true;
            int i = 0;
            while (i < otherP.length && b) {
                b &= this.otherPrimeInfo[i].getPrime().equals(otherP[i].getPrime());
                b &= this.otherPrimeInfo[i].getExponent().equals(otherP[i].getExponent());
                b &= this.otherPrimeInfo[i].getCrtCoefficient().equals(otherP[i].getCrtCoefficient());
                ++i;
            }
            return b;
        }
        return false;
    }

    public String toString() {
        String out = "";
        out = out + "modulus n:           0x" + this.n.toString(16) + "\n";
        out = out + "public exponent e:   0x" + this.e.toString(16) + "\n";
        out = out + "private exponent d:  0x" + this.d.toString(16) + "\n";
        out = out + "prime P:             0x" + this.p.toString(16) + "\n";
        out = out + "prime Q:             0x" + this.q.toString(16) + "\n";
        out = out + "prime exponent P:    0x" + this.dP.toString(16) + "\n";
        out = out + "prime exponent Q:    0x" + this.dQ.toString(16) + "\n";
        out = out + "crt coefficient:     0x" + this.crtCoeff.toString(16) + "\n";
        int i = 1;
        while (i <= this.otherPrimeInfo.length) {
            out = out + "prime r" + i + ":            0x" + this.otherPrimeInfo[i - 1].getPrime().toString(16) + "\n" + "prime exponent d" + i + ":   0x" + this.otherPrimeInfo[i - 1].getExponent().toString(16) + "\n" + "crt coefficient t" + i + ":  0x" + this.otherPrimeInfo[i - 1].getCrtCoefficient().toString(16) + "\n";
            ++i;
        }
        return out;
    }

    public int hashCode() {
        int h = this.n.hashCode() + this.d.hashCode() + this.e.hashCode() + this.p.hashCode() + this.q.hashCode() + this.dP.hashCode() + this.dQ.hashCode() + this.crtCoeff.hashCode();
        int i = 0;
        while (i < this.otherPrimeInfo.length) {
            h = this.otherPrimeInfo[i].getPrime().hashCode() + this.otherPrimeInfo[i].getExponent().hashCode() + this.otherPrimeInfo[i].getCrtCoefficient().hashCode();
            ++i;
        }
        return h;
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier();
    }

    protected ASN1Type getAlgParams() {
        return new ASN1Null();
    }

    protected byte[] getKeyData() {
        ASN1Sequence keyData = new ASN1Sequence();
        keyData.add(new ASN1Integer(0));
        keyData.add(ASN1Tools.createInteger(this.n));
        keyData.add(ASN1Tools.createInteger(this.e));
        keyData.add(ASN1Tools.createInteger(this.d));
        keyData.add(ASN1Tools.createInteger(this.p));
        keyData.add(ASN1Tools.createInteger(this.q));
        keyData.add(ASN1Tools.createInteger(this.dP));
        keyData.add(ASN1Tools.createInteger(this.dQ));
        keyData.add(ASN1Tools.createInteger(this.crtCoeff));
        ASN1Sequence otherPrimesSeq = new ASN1Sequence();
        int i = 0;
        while (i < this.otherPrimeInfo.length) {
            ASN1Integer prime_ = ASN1Tools.createInteger(this.otherPrimeInfo[i].getPrime());
            ASN1Integer exponent_ = ASN1Tools.createInteger(this.otherPrimeInfo[i].getExponent());
            ASN1Integer crtCoefficient_ = ASN1Tools.createInteger(this.otherPrimeInfo[i].getCrtCoefficient());
            ASN1Sequence seq_i = new ASN1Sequence();
            seq_i.add(prime_);
            seq_i.add(exponent_);
            seq_i.add(crtCoefficient_);
            otherPrimesSeq.add(seq_i);
            ++i;
        }
        keyData.add(otherPrimesSeq);
        return ASN1Tools.derEncode((ASN1Type)keyData);
    }
}

