/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.kdf;

import de.flexiprovider.api.KeyDerivation;
import de.flexiprovider.api.Mac;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.InvalidKeySpecException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyFactory;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.BigEndianConversions;
import de.flexiprovider.common.util.ByteUtils;
import de.flexiprovider.core.kdf.PBKDF2ParameterSpec;
import de.flexiprovider.core.mac.HMac;
import de.flexiprovider.core.mac.HMacKeyFactory;

public class PBKDF2
extends KeyDerivation {
    public static final String OID = "1.2.840.113549.1.5.12";
    private Mac mac = new HMac.SHA1();
    private SecretKey hmacKey;
    private byte[] salt;
    private int iterationCount;

    public void init(byte[] secret, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secret == null) {
            throw new InvalidKeyException("null");
        }
        SecretKeySpec hmacKeySpec = new SecretKeySpec(secret, "HmacSHA1");
        HMacKeyFactory skf = new HMacKeyFactory();
        try {
            this.hmacKey = ((SecretKeyFactory)skf).generateSecret(hmacKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("internal error");
        }
        if (!(params instanceof PBKDF2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        PBKDF2ParameterSpec kdfParams = (PBKDF2ParameterSpec)params;
        this.salt = kdfParams.getSalt();
        this.iterationCount = kdfParams.getIterationCount();
    }

    public byte[] deriveKey(int keySize) {
        if (keySize < 0) {
            return null;
        }
        int hLen = this.mac.getMacLength();
        int l = (keySize + hLen - 1) / hLen;
        byte[] tempKey = new byte[l * hLen];
        int i = 0;
        int pos = 0;
        while (i < l) {
            byte[] ti = this.f(i);
            System.arraycopy(ti, 0, tempKey, pos, ti.length);
            pos += ti.length;
            ++i;
        }
        byte[] result = new byte[keySize];
        System.arraycopy(tempKey, 0, result, 0, keySize);
        return result;
    }

    private byte[] f(int i) {
        byte[] iBytes = BigEndianConversions.I2OSP(i);
        byte[] sAndI = ByteUtils.concatenate(this.salt, iBytes);
        try {
            this.mac.init(this.hmacKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("internal error");
        }
        byte[] u = this.mac.doFinal(sAndI);
        byte[] result = new byte[u.length];
        int j = 0;
        while (j < this.iterationCount) {
            ByteUtils.xor(result, u);
            try {
                this.mac.init(this.hmacKey);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("internal error");
            }
            u = this.mac.doFinal(u);
            ++j;
        }
        ByteUtils.xor(result, u);
        return result;
    }
}

