/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.idea;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.idea.IDEAKey;

public class IDEAKeyGenerator
extends SecretKeyGenerator {
    public static final int IDEA_KEY_SIZE = 16;
    private SecureRandom random;
    private boolean initialized;

    public void init(AlgorithmParameterSpec params, SecureRandom random) {
        this.init(random);
    }

    public void init(int keySize, SecureRandom random) {
        this.init(random);
    }

    public void init(SecureRandom random) {
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] keyBytes = new byte[16];
        this.random.nextBytes(keyBytes);
        return new IDEAKey(keyBytes);
    }
}

