/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.desede;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.NoSuchModeException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.BigEndianConversions;
import de.flexiprovider.core.desede.DESedeKey;

public class DESede
extends BlockCipher {
    public static final String ALG_NAME = "DESede";
    public static final int blockSize = 8;
    private int[][] keys = new int[3][32];
    private static int[] S1 = new int[]{0x808200, 0, 32768, 0x808202, 0x808002, 33282, 2, 32768, 512, 0x808200, 0x808202, 512, 0x800202, 0x808002, 0x800000, 2, 514, 0x800200, 0x800200, 33280, 33280, 0x808000, 0x808000, 0x800202, 32770, 0x800002, 0x800002, 32770, 0, 514, 33282, 0x800000, 32768, 0x808202, 2, 0x808000, 0x808200, 0x800000, 0x800000, 512, 0x808002, 32768, 33280, 0x800002, 512, 2, 0x800202, 33282, 0x808202, 32770, 0x808000, 0x800202, 0x800002, 514, 33282, 0x808200, 514, 0x800200, 0x800200, 0, 32770, 33280, 0, 0x808002};
    private static int[] S2 = new int[]{1074282512, 0x40004000, 16384, 540688, 524288, 16, 1074266128, 0x40004010, 0x40000010, 1074282512, 0x40084000, 0x40000000, 0x40004000, 524288, 16, 1074266128, 540672, 524304, 0x40004010, 0, 0x40000000, 16384, 540688, 0x40080000, 524304, 0x40000010, 0, 540672, 16400, 0x40084000, 0x40080000, 16400, 0, 540688, 1074266128, 524288, 0x40004010, 0x40080000, 0x40084000, 16384, 0x40080000, 0x40004000, 16, 1074282512, 540688, 16, 16384, 0x40000000, 16400, 0x40084000, 524288, 0x40000010, 524304, 0x40004010, 0x40000010, 524304, 540672, 0, 0x40004000, 16400, 0x40000000, 1074266128, 1074282512, 540672};
    private static int[] S3 = new int[]{260, 0x4010100, 0, 0x4010004, 0x4000100, 0, 65796, 0x4000100, 65540, 0x4000004, 0x4000004, 65536, 0x4010104, 65540, 0x4010000, 260, 0x4000000, 4, 0x4010100, 256, 65792, 0x4010000, 0x4010004, 65796, 0x4000104, 65792, 65536, 0x4000104, 4, 0x4010104, 256, 0x4000000, 0x4010100, 0x4000000, 65540, 260, 65536, 0x4010100, 0x4000100, 0, 256, 65540, 0x4010104, 0x4000100, 0x4000004, 256, 0, 0x4010004, 0x4000104, 65536, 0x4000000, 0x4010104, 4, 65796, 65792, 0x4000004, 0x4010000, 0x4000104, 260, 0x4010000, 65796, 4, 0x4010004, 65792};
    private static int[] S4 = new int[]{-2143285248, -2147479488, -2147479488, 64, 0x401040, -2143289280, -2143289344, -2147479552, 0, 0x401000, 0x401000, -2143285184, -2147483584, 0, 0x400040, -2143289344, Integer.MIN_VALUE, 4096, 0x400000, -2143285248, 64, 0x400000, -2147479552, 4160, -2143289280, Integer.MIN_VALUE, 4160, 0x400040, 4096, 0x401040, -2143285184, -2147483584, 0x400040, -2143289344, 0x401000, -2143285184, -2147483584, 0, 0, 0x401000, 4160, 0x400040, -2143289280, Integer.MIN_VALUE, -2143285248, -2147479488, -2147479488, 64, -2143285184, -2147483584, Integer.MIN_VALUE, 4096, -2143289344, -2147479552, 0x401040, -2143289280, -2147479552, 4160, 0x400000, -2143285248, 64, 0x400000, 4096, 0x401040};
    private static int[] S5 = new int[]{128, 17039488, 0x1040000, 553648256, 262144, 128, 0x20000000, 0x1040000, 537133184, 262144, 0x1000080, 537133184, 553648256, 553910272, 262272, 0x20000000, 0x1000000, 0x20040000, 0x20040000, 0, 0x20000080, 553910400, 553910400, 0x1000080, 553910272, 0x20000080, 0, 0x21000000, 17039488, 0x1000000, 0x21000000, 262272, 262144, 553648256, 128, 0x1000000, 0x20000000, 0x1040000, 553648256, 537133184, 0x1000080, 0x20000000, 553910272, 17039488, 537133184, 128, 0x1000000, 553910272, 553910400, 262272, 0x21000000, 553910400, 0x1040000, 0, 0x20040000, 0x21000000, 262272, 0x1000080, 0x20000080, 262144, 0, 0x20040000, 17039488, 0x20000080};
    private static int[] S6 = new int[]{0x10000008, 0x10200000, 8192, 270540808, 0x10200000, 8, 270540808, 0x200000, 0x10002000, 0x202008, 0x200000, 0x10000008, 0x200008, 0x10002000, 0x10000000, 8200, 0, 0x200008, 268443656, 8192, 0x202000, 268443656, 8, 270532616, 270532616, 0, 0x202008, 0x10202000, 8200, 0x202000, 0x10202000, 0x10000000, 0x10002000, 8, 270532616, 0x202000, 270540808, 0x200000, 8200, 0x10000008, 0x200000, 0x10002000, 0x10000000, 8200, 0x10000008, 270540808, 0x202000, 0x10200000, 0x202008, 0x10202000, 0, 270532616, 8, 8192, 0x10200000, 0x202008, 8192, 0x200008, 268443656, 0, 0x10202000, 0x10000000, 0x200008, 268443656};
    private static int[] S7 = new int[]{0x100000, 0x2100001, 33555457, 0, 1024, 33555457, 0x100401, 34604032, 34604033, 0x100000, 0, 0x2000001, 1, 0x2000000, 0x2100001, 1025, 0x2000400, 0x100401, 0x100001, 0x2000400, 0x2000001, 0x2100000, 34604032, 0x100001, 0x2100000, 1024, 1025, 34604033, 0x100400, 1, 0x2000000, 0x100400, 0x2000000, 0x100400, 0x100000, 33555457, 33555457, 0x2100001, 0x2100001, 1, 0x100001, 0x2000000, 0x2000400, 0x100000, 34604032, 1025, 0x100401, 34604032, 1025, 0x2000001, 34604033, 0x2100000, 0x100400, 0, 1, 34604033, 0, 0x100401, 0x2100000, 1024, 0x2000001, 0x2000400, 1024, 0x100001};
    private static int[] S8 = new int[]{0x8000820, 2048, 131072, 0x8020820, 0x8000000, 0x8000820, 32, 0x8000000, 131104, 0x8020000, 0x8020820, 133120, 0x8020800, 133152, 2048, 32, 0x8020000, 0x8000020, 0x8000800, 2080, 133120, 131104, 0x8020020, 0x8020800, 2080, 0, 0, 0x8020020, 0x8000020, 0x8000800, 133152, 131072, 133152, 131072, 0x8020800, 2048, 32, 0x8020020, 2048, 133152, 0x8000800, 32, 0x8000020, 0x8020000, 0x8020020, 0x8000000, 131072, 0x8000820, 0, 0x8020820, 131104, 0x8000020, 0x8020000, 0x8000800, 0x8000820, 0, 0x8020820, 133120, 133120, 2080, 2080, 131104, 0x8000000, 0x8020800};

    public String getName() {
        return ALG_NAME;
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        boolean tripleDES = false;
        if (!(key instanceof DESedeKey) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("not a DESede Key");
        }
        byte[] keyBytes = key.getEncoded();
        int i = 0;
        while (i < 8) {
            if (keyBytes[i] != keyBytes[i + 8] || keyBytes[i + 8] != keyBytes[i + 16]) {
                tripleDES = true;
                break;
            }
            ++i;
        }
        return tripleDES ? 112 : 56;
    }

    public int getCipherBlockSize() {
        return 8;
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (!(key instanceof DESedeKey)) {
            throw new InvalidKeyException("Not an instance of DESedeKey.");
        }
        this.keySchedule(key.getEncoded());
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.initCipherEncrypt(key, params);
    }

    private void keySchedule(byte[] key) {
        int[] deskey = new int[2];
        int i = 0;
        while (i < 3) {
            deskey[0] = ((key[i << 3] & 0xFF) << 24) + ((key[(i << 3) + 1] & 0xFF) << 16) + ((key[(i << 3) + 2] & 0xFF) << 8) + (key[(i << 3) + 3] & 0xFF);
            deskey[1] = ((key[(i << 3) + 4] & 0xFF) << 24) + ((key[(i << 3) + 5] & 0xFF) << 16) + ((key[(i << 3) + 6] & 0xFF) << 8) + (key[(i << 3) + 7] & 0xFF);
            int c = (deskey[1] & 0x80) << 24;
            c |= (deskey[1] & 0x8000) << 15;
            c |= (deskey[1] & 0x800000) << 6;
            c |= (deskey[1] & Integer.MIN_VALUE) >>> 3;
            c |= (deskey[0] & 0x80) << 20;
            c |= (deskey[0] & 0x8000) << 11;
            c |= (deskey[0] & 0x800000) << 2;
            c |= (deskey[0] & Integer.MIN_VALUE) >>> 7;
            c |= (deskey[1] & 0x40) << 17;
            c |= (deskey[1] & 0x4000) << 8;
            c |= (deskey[1] & 0x400000) >>> 1;
            c |= (deskey[1] & 0x40000000) >>> 10;
            c |= (deskey[0] & 0x40) << 13;
            c |= (deskey[0] & 0x4000) << 4;
            c |= (deskey[0] & 0x400000) >>> 5;
            c |= (deskey[0] & 0x40000000) >>> 14;
            c |= (deskey[1] & 0x20) << 10;
            c |= (deskey[1] & 0x2000) << 1;
            c |= (deskey[1] & 0x200000) >>> 8;
            c |= (deskey[1] & 0x20000000) >>> 17;
            c |= (deskey[0] & 0x20) << 6;
            c |= (deskey[0] & 0x2000) >>> 3;
            c |= (deskey[0] & 0x200000) >>> 12;
            c |= (deskey[0] & 0x20000000) >>> 21;
            c |= (deskey[1] & 0x10) << 3;
            c |= (deskey[1] & 0x1000) >>> 6;
            c |= (deskey[1] & 0x100000) >>> 15;
            c |= (deskey[1] & 0x10000000) >>> 24;
            int d = (deskey[1] & 2) << 30;
            d |= (deskey[1] & 0x204) << 21;
            d |= (deskey[1] & 0x20408) << 12;
            d |= (deskey[1] & 0x2040800) << 3;
            d |= (deskey[0] & 2) << 26;
            d |= (deskey[0] & 0x204) << 17;
            d |= (deskey[0] & 0x20408) << 8;
            d |= (deskey[0] & 0x2040800) >>> 1;
            d |= (deskey[1] & 0x4080000) >>> 6;
            d |= (deskey[0] & 0x4080000) >>> 10;
            d |= (deskey[1] & 0x8000000) >>> 15;
            d |= (deskey[0] & 0x8000000) >>> 19;
            d |= (deskey[0] & 0x10) << 3;
            d |= (deskey[0] & 0x1000) >>> 6;
            d |= (deskey[0] & 0x100000) >>> 15;
            d |= (deskey[0] & 0x10000000) >>> 24;
            int j = 0;
            int l = 0;
            int r = 1;
            while (j < 16) {
                switch (j) {
                    case 0: 
                    case 1: 
                    case 8: 
                    case 15: {
                        c = c << 1 & 0xFFFFFFE0 | (c & Integer.MIN_VALUE) >>> 27;
                        d = d << 1 & 0xFFFFFFE0 | (d & Integer.MIN_VALUE) >>> 27;
                        break;
                    }
                    default: {
                        c = c << 2 & 0xFFFFFFC0 | (c & 0xC0000000) >>> 26;
                        d = d << 2 & 0xFFFFFFC0 | (d & 0xC0000000) >>> 26;
                    }
                }
                this.keys[i][l] = (c & 0x40000) << 5;
                int[] nArray = this.keys[i];
                int n = l;
                nArray[n] = nArray[n] | (c & 0x8000) << 7;
                int[] nArray2 = this.keys[i];
                int n2 = l;
                nArray2[n2] = nArray2[n2] | c & 0x200000;
                int[] nArray3 = this.keys[i];
                int n3 = l;
                nArray3[n3] = nArray3[n3] | (c & 0x110) << 12;
                int[] nArray4 = this.keys[i];
                int n4 = l;
                nArray4[n4] = nArray4[n4] | (c & 0xA4000000) >>> 12;
                int[] nArray5 = this.keys[i];
                int n5 = l;
                nArray5[n5] = nArray5[n5] | (c & 0x8000000) >>> 9;
                int[] nArray6 = this.keys[i];
                int n6 = l;
                nArray6[n6] = nArray6[n6] | (c & 0x20020) >>> 2;
                int[] nArray7 = this.keys[i];
                int n7 = l;
                nArray7[n7] = nArray7[n7] | (c & 0xA00) << 2;
                int[] nArray8 = this.keys[i];
                int n8 = l;
                nArray8[n8] = nArray8[n8] | (c & 0x401000) >>> 10;
                int[] nArray9 = this.keys[i];
                int n9 = l;
                nArray9[n9] = nArray9[n9] | (c & 0x2000) >>> 3;
                int[] nArray10 = this.keys[i];
                int n10 = l;
                nArray10[n10] = nArray10[n10] | (c & 0x110000) >>> 11;
                int[] nArray11 = this.keys[i];
                int n11 = l;
                nArray11[n11] = nArray11[n11] | (c & 0x10000000) >>> 20;
                int[] nArray12 = this.keys[i];
                int n12 = l;
                nArray12[n12] = nArray12[n12] | (c & 0x40) << 1;
                int[] nArray13 = this.keys[i];
                int n13 = l;
                nArray13[n13] = nArray13[n13] | (c & 0x1080000) >>> 18;
                int[] nArray14 = this.keys[i];
                int n14 = l;
                nArray14[n14] = nArray14[n14] | (c & 0x2000000) >>> 21;
                int[] nArray15 = this.keys[i];
                int n15 = l;
                nArray15[n15] = nArray15[n15] | (c & 0x40000000) >>> 30;
                this.keys[i][r] = (d & 0x80010) << 4;
                int[] nArray16 = this.keys[i];
                int n16 = r;
                nArray16[n16] = nArray16[n16] | (d & 0x100) << 14;
                int[] nArray17 = this.keys[i];
                int n17 = r;
                nArray17[n17] = nArray17[n17] | (d & 0x20000000) >>> 8;
                int[] nArray18 = this.keys[i];
                int n18 = r;
                nArray18[n18] = nArray18[n18] | (d & 0x800000) >>> 3;
                int[] nArray19 = this.keys[i];
                int n19 = r;
                nArray19[n19] = nArray19[n19] | (d & 0x2200) << 6;
                int[] nArray20 = this.keys[i];
                int n20 = r;
                nArray20[n20] = nArray20[n20] | (d & 0x20) << 13;
                int[] nArray21 = this.keys[i];
                int n21 = r;
                nArray21[n21] = nArray21[n21] | (d & 0x40000000) >>> 13;
                int[] nArray22 = this.keys[i];
                int n22 = r;
                nArray22[n22] = nArray22[n22] | (d & 0x100000) >>> 4;
                int[] nArray23 = this.keys[i];
                int n23 = r;
                nArray23[n23] = nArray23[n23] | (d & 0x8880) >>> 1;
                int[] nArray24 = this.keys[i];
                int n24 = r;
                nArray24[n24] = nArray24[n24] | (d & 0x8040000) >>> 14;
                int[] nArray25 = this.keys[i];
                int n25 = r;
                nArray25[n25] = nArray25[n25] | d & 0x1000;
                int[] nArray26 = this.keys[i];
                int n26 = r;
                nArray26[n26] = nArray26[n26] | (d & 0x10000) >>> 5;
                int[] nArray27 = this.keys[i];
                int n27 = r;
                nArray27[n27] = nArray27[n27] | (d & 0x200000) >>> 12;
                int[] nArray28 = this.keys[i];
                int n28 = r;
                nArray28[n28] = nArray28[n28] | (d & 0x4000000) >>> 19;
                int[] nArray29 = this.keys[i];
                int n29 = r;
                nArray29[n29] = nArray29[n29] | (d & 0x4000) >>> 9;
                int[] nArray30 = this.keys[i];
                int n30 = r;
                nArray30[n30] = nArray30[n30] | (d & 0x400) >>> 7;
                int[] nArray31 = this.keys[i];
                int n31 = r;
                nArray31[n31] = nArray31[n31] | (d & 0x1000000) >>> 22;
                int[] nArray32 = this.keys[i];
                int n32 = r;
                nArray32[n32] = nArray32[n32] | (d & Integer.MIN_VALUE) >>> 30;
                int[] nArray33 = this.keys[i];
                int n33 = r;
                nArray33[n33] = nArray33[n33] | (d & 0x10000000) >>> 28;
                l = ++j << 1;
                r = l + 1;
            }
            ++i;
        }
    }

    protected void singleBlockEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        long block = BigEndianConversions.OS2LIP(input, inOff);
        block = this.initialPermutation(block);
        block = this.encryptDES(0, block);
        block = this.decryptDES(1, block);
        block = this.encryptDES(2, block);
        block = this.finalPermutation(block);
        BigEndianConversions.I2OSP(block, output, outOff);
    }

    protected void singleBlockDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        long block = BigEndianConversions.OS2LIP(input, inOff);
        block = this.initialPermutation(block);
        block = this.decryptDES(2, block);
        block = this.encryptDES(1, block);
        block = this.decryptDES(0, block);
        block = this.finalPermutation(block);
        BigEndianConversions.I2OSP(block, output, outOff);
    }

    private long encryptDES(int key, long in) {
        int L = (int)(in >>> 32);
        int R = (int)in;
        int i = 0;
        while (i < 16) {
            int save = L;
            L = R;
            int left = (R & 1) << 23 | (R & 0xF8000000) >>> 9 | (R & 0x1F800000) >>> 11 | (R & 0x1F80000) >>> 13 | (R & 0x1F8000) >>> 15;
            int right = (R & 0x1F800) << 7 | (R & 0x1F80) << 5 | (R & 0x1F8) << 3 | (R & 0x1F) << 1 | (R & Integer.MIN_VALUE) >>> 31;
            int c = S1[(left ^= this.keys[key][i << 1]) >>> 18] | S2[left >>> 12 & 0x3F] | S3[left >>> 6 & 0x3F] | S4[left & 0x3F] | S5[(right ^= this.keys[key][(i << 1) + 1]) >>> 18] | S6[right >>> 12 & 0x3F] | S7[right >>> 6 & 0x3F] | S8[right & 0x3F];
            R = save ^ c;
            ++i;
        }
        return (long)R << 32 | (long)L << 32 >>> 32;
    }

    private long decryptDES(int key, long in) {
        int L = (int)(in >>> 32);
        int R = (int)in;
        int i = 15;
        while (i > -1) {
            int save = L;
            L = R;
            int left = (R & 1) << 23 | (R & 0xF8000000) >>> 9 | (R & 0x1F800000) >>> 11 | (R & 0x1F80000) >>> 13 | (R & 0x1F8000) >>> 15;
            int right = (R & 0x1F800) << 7 | (R & 0x1F80) << 5 | (R & 0x1F8) << 3 | (R & 0x1F) << 1 | (R & Integer.MIN_VALUE) >>> 31;
            int c = S1[(left ^= this.keys[key][i << 1]) >>> 18] | S2[left >>> 12 & 0x3F] | S3[left >>> 6 & 0x3F] | S4[left & 0x3F] | S5[(right ^= this.keys[key][(i << 1) + 1]) >>> 18] | S6[right >>> 12 & 0x3F] | S7[right >>> 6 & 0x3F] | S8[right & 0x3F];
            R = save ^ c;
            --i;
        }
        return (long)R << 32 | (long)L << 32 >>> 32;
    }

    private long initialPermutation(long in) {
        long result = (in & 0x40L) << 57;
        result |= (in & 0x4000L) << 48;
        result |= (in & 0x400001L) << 39;
        result |= (in & 0x40000100L) << 30;
        result |= (in & 0x4000010000L) << 21;
        result |= (in & 0x400001000008L) << 12;
        result |= (in & 0x40000100000800L) << 3;
        result |= (in & 0x10L) << 51;
        result |= (in & 0x1000L) << 42;
        result |= (in & 0x100000L) << 33;
        result |= (in & 0x10000080L) << 24;
        result |= (in & 0x1000008000L) << 15;
        result |= (in & 0x100000800002L) << 6;
        result |= (in & 4L) << 45;
        result |= (in & 0x400L) << 36;
        result |= (in & 0x40000L) << 27;
        result |= (in & 0x4000020L) << 18;
        result |= (in & 0x400002000L) << 9;
        result |= in & 0x40000200000L;
        result |= (in & 0x4000010000080000L) >>> 6;
        result |= (in & 0x10000080000200L) >>> 3;
        result |= (in & 0x1000008000020000L) >>> 12;
        result |= (in & 0x4000020000000L) >>> 9;
        result |= (in & 0x400002000000000L) >>> 18;
        result |= (in & 0x1000008000000L) >>> 15;
        result |= (in & 0x100000800000000L) >>> 24;
        result |= (in & 0x800002000000L) >>> 21;
        result |= (in & 0x80000200000000L) >>> 30;
        result |= (in & 0x8000020000000000L) >>> 39;
        result |= (in & 0x200000000000L) >>> 27;
        result |= (in & 0x20000000000000L) >>> 36;
        result |= (in & 0x2000000000000000L) >>> 45;
        result |= (in & 0x80000000000L) >>> 33;
        result |= (in & 0x8000000000000L) >>> 42;
        result |= (in & 0x800000000000000L) >>> 51;
        result |= (in & 0x2000000000000L) >>> 48;
        return result |= (in & 0x200000000000000L) >>> 57;
    }

    private long finalPermutation(long in) {
        long result = (in & 0x1000004L) << 39;
        result |= (in & 0x100000400002000L) << 6;
        result |= (in & 0x10000L) << 45;
        result |= (in & 0x1000008000020L) << 12;
        result |= (in & 0x100L) << 51;
        result |= (in & 0x10000080000L) << 18;
        result |= (in & 1L) << 57;
        result |= (in & 0x100000800L) << 24;
        result |= (in & 0x2000008L) << 30;
        result |= (in & 0x20000L) << 36;
        result |= (in & 0x2000010000040L) << 3;
        result |= (in & 0x200L) << 42;
        result |= (in & 0x20000100000L) << 9;
        result |= (in & 2L) << 48;
        result |= (in & 0x200001000L) << 15;
        result |= (in & 0x4000010L) << 21;
        result |= (in & 0x40000L) << 27;
        result |= (in & 0x400L) << 33;
        result |= in & 0x40000200000L;
        result |= (in & 0x200000800004000L) >>> 3;
        result |= (in & 0x400001000008000L) >>> 12;
        result |= (in & 0x4000020000080L) >>> 6;
        result |= (in & 0x800002000000000L) >>> 21;
        result |= (in & 0x8000040000000L) >>> 15;
        result |= (in & 0x80000400000L) >>> 9;
        result |= (in & 0x1000004000000000L) >>> 30;
        result |= (in & 0x10000080000000L) >>> 24;
        result |= (in & 0x100000800000L) >>> 18;
        result |= (in & 0x2000008000000000L) >>> 39;
        result |= (in & 0x20000000000000L) >>> 33;
        result |= (in & 0x200000000000L) >>> 27;
        result |= (in & 0x4000000000000000L) >>> 48;
        result |= (in & 0x40000000000000L) >>> 42;
        result |= (in & 0x400000000000L) >>> 36;
        result |= (in & Long.MIN_VALUE) >>> 57;
        result |= (in & 0x80000000000000L) >>> 51;
        return result |= (in & 0x800000000000L) >>> 45;
    }

    public static class DESede_CBC
    extends DESede {
        public static final String ALG_NAME = "DESede_CBC";
        public static final String OID = "1.2.840.113549.3.7";

        public DESede_CBC() {
            try {
                this.setMode("CBC");
            }
            catch (NoSuchModeException e) {
                throw new RuntimeException("Internal error: could not find CBC mode.");
            }
        }

        public String getName() {
            return ALG_NAME;
        }
    }
}

