/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api.keys;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Type;
import codec.pkcs8.PrivateKeyInfo;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.pki.AlgorithmIdentifier;

public abstract class PrivateKey
implements Key,
java.security.PrivateKey {
    public final String getFormat() {
        return "PKCS#8";
    }

    public final byte[] getEncoded() {
        AlgorithmIdentifier aid;
        try {
            aid = new AlgorithmIdentifier(this.getOID(), this.getAlgParams());
        }
        catch (ASN1Exception asn1e) {
            throw new RuntimeException("ASN1Exception: " + asn1e.getMessage());
        }
        PrivateKeyInfo spki = new PrivateKeyInfo((codec.x509.AlgorithmIdentifier)aid, this.getKeyData());
        return ASN1Tools.derEncode((ASN1Type)spki);
    }

    protected abstract ASN1ObjectIdentifier getOID();

    protected abstract ASN1Type getAlgParams();

    protected abstract byte[] getKeyData();

    public abstract String getAlgorithm();
}

