/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityExpressionRoot {
    protected final Authentication authentication;
    private AuthenticationTrustResolver trustResolver;
    private RoleHierarchy roleHierarchy;
    private Set<String> roles;
    public final boolean permitAll = true;
    public final boolean denyAll = false;

    public SecurityExpressionRoot(Authentication a) {
        if (a == null) {
            throw new IllegalArgumentException("Authentication object cannot be null");
        }
        this.authentication = a;
    }

    public final boolean hasAuthority(String authority) {
        return this.hasRole(authority);
    }

    public final boolean hasAnyAuthority(String ... authorities) {
        return this.hasAnyRole(authorities);
    }

    public final boolean hasRole(String role) {
        return this.getAuthoritySet().contains(role);
    }

    public final boolean hasAnyRole(String ... roles) {
        Set<String> roleSet = this.getAuthoritySet();
        for (String role : roles) {
            if (!roleSet.contains(role)) continue;
            return true;
        }
        return false;
    }

    public final Authentication getAuthentication() {
        return this.authentication;
    }

    public final boolean permitAll() {
        return true;
    }

    public final boolean denyAll() {
        return false;
    }

    public final boolean isAnonymous() {
        return this.trustResolver.isAnonymous(this.authentication);
    }

    public final boolean isAuthenticated() {
        return !this.isAnonymous();
    }

    public final boolean isRememberMe() {
        return this.trustResolver.isRememberMe(this.authentication);
    }

    public final boolean isFullyAuthenticated() {
        return !this.trustResolver.isAnonymous(this.authentication) && !this.trustResolver.isRememberMe(this.authentication);
    }

    public Object getPrincipal() {
        return this.authentication.getPrincipal();
    }

    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.trustResolver = trustResolver;
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        this.roleHierarchy = roleHierarchy;
    }

    private Set<String> getAuthoritySet() {
        if (this.roles == null) {
            this.roles = new HashSet<String>();
            Collection<GrantedAuthority> userAuthorities = this.authentication.getAuthorities();
            if (this.roleHierarchy != null) {
                userAuthorities = this.roleHierarchy.getReachableGrantedAuthorities(userAuthorities);
            }
            this.roles = AuthorityUtils.authorityListToSet(userAuthorities);
        }
        return this.roles;
    }
}

