/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import java.util.Random;

public class SparkleFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = 1692413049411710802L;
    private int rays = 50;
    private int radius = 25;
    private int amount = 50;
    private int color = -1;
    private int randomness = 25;
    private int width;
    private int height;
    private int centreX;
    private int centreY;
    private long seed = 371L;
    private double[] rayLengths;
    private Random randomNumbers = new Random();

    public void setColor(int n) {
        this.color = n;
    }

    public int getColor() {
        return this.color;
    }

    public void setRandomness(int n) {
        this.randomness = n;
    }

    public int getRandomness() {
        return this.randomness;
    }

    public void setAmount(int n) {
        this.amount = n;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setRays(int n) {
        this.rays = n;
    }

    public int getRays() {
        return this.rays;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.centreX = n / 2;
        this.centreY = n2 / 2;
        super.setDimensions(n, n2);
        this.randomNumbers.setSeed(this.seed);
        this.rayLengths = new double[this.rays];
        int n3 = 0;
        while (n3 < this.rays) {
            this.rayLengths[n3] = (double)this.radius + (double)this.randomness / 100.0 * (double)this.radius * this.randomNumbers.nextGaussian();
            ++n3;
        }
    }

    public int filterRGB(int n, int n2, int n3) {
        double d = n - this.centreX;
        double d2 = n2 - this.centreY;
        double d3 = d * d + d2 * d2;
        double d4 = Math.atan2(d2, d);
        double d5 = (d4 + Math.PI) / (Math.PI * 2) * (double)this.rays;
        int n4 = (int)d5;
        double d6 = d5 - (double)n4;
        if (this.radius != 0) {
            double d7 = ImageMath.lerp(d6, this.rayLengths[n4 % this.rays], this.rayLengths[(n4 + 1) % this.rays]);
            double d8 = d7 * d7 / (d3 + 1.0E-4);
            d8 = Math.pow(d8, (double)(100 - this.amount) / 50.0);
            d6 -= 0.5;
            d6 = 1.0 - d6 * d6;
            d6 *= d8;
        }
        d6 = ImageMath.clamp(d6, 0.0, 1.0);
        return ImageMath.mixColors(d6, n3, this.color);
    }

    public String toString() {
        return "Stylize/Sparkle...";
    }
}

