/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.osgi;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.management.ScriptEngineManagerContext;
import com.hazelcast.osgi.OSGiScriptEngineManager;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String HAZELCAST_OSGI_START = "hazelcast.osgi.start";
    private HazelcastInstance hazelcastInstance;
    private final ILogger logger = Logger.getLogger(Activator.class);

    public void start(BundleContext context) throws Exception {
        OSGiScriptEngineManager scriptEngineManager = new OSGiScriptEngineManager(context);
        ScriptEngineManagerContext.setScriptEngineManager(scriptEngineManager);
        if (this.logger.isFinestEnabled()) {
            StringBuilder msg = new StringBuilder("Available script engines are:");
            for (ScriptEngineFactory scriptEngineFactory : ((ScriptEngineManager)scriptEngineManager).getEngineFactories()) {
                msg.append(scriptEngineFactory.getEngineName()).append('\n');
            }
            this.logger.finest(msg.toString());
        }
        if (System.getProperty(HAZELCAST_OSGI_START) != null) {
            this.hazelcastInstance = Hazelcast.newHazelcastInstance();
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (System.getProperty(HAZELCAST_OSGI_START) != null) {
            this.hazelcastInstance.shutdown();
        }
    }
}

