/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.operations;

import com.hazelcast.concurrent.lock.ConditionKey;
import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.concurrent.lock.operations.AwaitOperation;
import com.hazelcast.concurrent.lock.operations.BaseLockOperation;
import com.hazelcast.concurrent.lock.operations.UnlockBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class UnlockOperation
extends BaseLockOperation
implements Notifier,
BackupAwareOperation {
    private boolean force;
    private boolean shouldNotify;

    public UnlockOperation() {
    }

    public UnlockOperation(ObjectNamespace namespace, Data key, long threadId) {
        super(namespace, key, threadId);
    }

    public UnlockOperation(ObjectNamespace namespace, Data key, long threadId, boolean force) {
        super(namespace, key, threadId);
        this.force = force;
    }

    @Override
    public void run() throws Exception {
        if (this.force) {
            this.forceUnlock();
        } else {
            this.unlock();
        }
    }

    private void unlock() {
        LockStoreImpl lockStore = this.getLockStore();
        boolean unlocked = lockStore.unlock(this.key, this.getCallerUuid(), this.threadId);
        this.response = unlocked;
        this.ensureUnlocked(lockStore, unlocked);
    }

    private void ensureUnlocked(LockStoreImpl lockStore, boolean unlocked) {
        if (!unlocked) {
            String ownerInfo = lockStore.getOwnerInfo(this.key);
            throw new IllegalMonitorStateException("Current thread is not owner of the lock! -> " + ownerInfo);
        }
    }

    private void forceUnlock() {
        LockStoreImpl lockStore = this.getLockStore();
        this.response = lockStore.forceUnlock(this.key);
    }

    @Override
    public void afterRun() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        AwaitOperation awaitResponse = lockStore.pollExpiredAwaitOp(this.key);
        if (awaitResponse != null) {
            OperationService operationService = this.getNodeEngine().getOperationService();
            operationService.runOperation(awaitResponse);
        }
        this.shouldNotify = awaitResponse == null;
    }

    @Override
    public Operation getBackupOperation() {
        return new UnlockBackupOperation(this.namespace, this.key, this.threadId, this.getCallerUuid(), this.force);
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public boolean shouldNotify() {
        return this.shouldNotify;
    }

    @Override
    public final WaitNotifyKey getNotifiedKey() {
        LockStoreImpl lockStore = this.getLockStore();
        ConditionKey conditionKey = lockStore.getSignalKey(this.key);
        if (conditionKey == null) {
            return new LockWaitNotifyKey(this.namespace, this.key);
        }
        return conditionKey;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.force);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.force = in.readBoolean();
    }
}

