/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.proxy.ClientConditionProxy;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.lock.client.GetLockCountRequest;
import com.hazelcast.concurrent.lock.client.GetRemainingLeaseRequest;
import com.hazelcast.concurrent.lock.client.IsLockedRequest;
import com.hazelcast.concurrent.lock.client.LockRequest;
import com.hazelcast.concurrent.lock.client.UnlockRequest;
import com.hazelcast.core.ICondition;
import com.hazelcast.core.ILock;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.ValidationUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class ClientLockProxy
extends ClientProxy
implements ILock {
    private volatile Data key;

    public ClientLockProxy(String instanceName, String serviceName, String objectId) {
        super(instanceName, serviceName, objectId);
    }

    @Override
    @Deprecated
    public Object getKey() {
        return this.getName();
    }

    @Override
    public boolean isLocked() {
        IsLockedRequest request = new IsLockedRequest(this.getKeyData());
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public boolean isLockedByCurrentThread() {
        IsLockedRequest request = new IsLockedRequest(this.getKeyData(), ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public int getLockCount() {
        GetLockCountRequest request = new GetLockCountRequest(this.getKeyData());
        return (Integer)this.invoke(request);
    }

    @Override
    public long getRemainingLeaseTime() {
        GetRemainingLeaseRequest request = new GetRemainingLeaseRequest(this.getKeyData());
        return (Long)this.invoke(request);
    }

    @Override
    public void lock(long leaseTime, TimeUnit timeUnit) {
        ValidationUtil.shouldBePositive(leaseTime, "leaseTime");
        LockRequest request = new LockRequest(this.getKeyData(), ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), -1L);
        this.invoke(request);
    }

    @Override
    public void forceUnlock() {
        UnlockRequest request = new UnlockRequest(this.getKeyData(), ThreadUtil.getThreadId(), true);
        this.invoke(request);
    }

    @Override
    public ICondition newCondition(String name) {
        return new ClientConditionProxy(this.instanceName, this, name, this.getContext());
    }

    @Override
    public void lock() {
        this.lock(Long.MAX_VALUE, null);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock();
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        LockRequest request = new LockRequest(this.getKeyData(), ThreadUtil.getThreadId(), Long.MAX_VALUE, this.getTimeInMillis(time, unit));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public void unlock() {
        UnlockRequest request = new UnlockRequest(this.getKeyData(), ThreadUtil.getThreadId());
        this.invoke(request);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void onDestroy() {
    }

    private Data getKeyData() {
        if (this.key == null) {
            this.key = this.toData(this.getName());
        }
        return this.key;
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    protected <T> T invoke(ClientRequest req) {
        return super.invoke(req, this.getKeyData());
    }

    public String toString() {
        return "ILock{name='" + this.getName() + '\'' + '}';
    }
}

