/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Random;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StreamError;

public class ReconnectionManager
extends AbstractConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(ReconnectionManager.class.getName());
    private XMPPConnection connection;
    private Thread reconnectionThread;
    private int randomBase = new Random().nextInt(11) + 5;
    boolean done = false;

    private ReconnectionManager(XMPPConnection connection) {
        this.connection = connection;
    }

    private boolean isReconnectionAllowed() {
        return !this.done && !this.connection.isConnected() && this.connection.getConfiguration().isReconnectionAllowed();
    }

    protected synchronized void reconnect() {
        if (this.isReconnectionAllowed()) {
            if (this.reconnectionThread != null && this.reconnectionThread.isAlive()) {
                return;
            }
            this.reconnectionThread = new Thread(){
                private int attempts = 0;

                private int timeDelay() {
                    ++this.attempts;
                    if (this.attempts > 13) {
                        return ReconnectionManager.this.randomBase * 6 * 5;
                    }
                    if (this.attempts > 7) {
                        return ReconnectionManager.this.randomBase * 6;
                    }
                    return ReconnectionManager.this.randomBase;
                }

                @Override
                public void run() {
                    while (ReconnectionManager.this.isReconnectionAllowed()) {
                        int remainingSeconds = this.timeDelay();
                        while (ReconnectionManager.this.isReconnectionAllowed() && remainingSeconds > 0) {
                            try {
                                Thread.sleep(1000L);
                                ReconnectionManager.this.notifyAttemptToReconnectIn(--remainingSeconds);
                            }
                            catch (InterruptedException e1) {
                                LOGGER.warning("Sleeping thread interrupted");
                                ReconnectionManager.this.notifyReconnectionFailed(e1);
                            }
                        }
                        try {
                            if (!ReconnectionManager.this.isReconnectionAllowed()) continue;
                            ReconnectionManager.this.connection.connect();
                        }
                        catch (Exception e) {
                            ReconnectionManager.this.notifyReconnectionFailed(e);
                        }
                    }
                }
            };
            this.reconnectionThread.setName("Smack Reconnection Manager");
            this.reconnectionThread.setDaemon(true);
            this.reconnectionThread.start();
        }
    }

    protected void notifyReconnectionFailed(Exception exception) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener listener : this.connection.connectionListeners) {
                listener.reconnectionFailed(exception);
            }
        }
    }

    protected void notifyAttemptToReconnectIn(int seconds) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener listener : this.connection.connectionListeners) {
                listener.reconnectingIn(seconds);
            }
        }
    }

    @Override
    public void connectionClosed() {
        this.done = true;
    }

    @Override
    public void connectionClosedOnError(Exception e) {
        XMPPException.StreamErrorException xmppEx;
        StreamError error;
        String reason;
        this.done = false;
        if (e instanceof XMPPException.StreamErrorException && "conflict".equals(reason = (error = (xmppEx = (XMPPException.StreamErrorException)e).getStreamError()).getCode())) {
            return;
        }
        if (this.isReconnectionAllowed()) {
            this.reconnect();
        }
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                connection.addConnectionListener(new ReconnectionManager(connection));
            }
        });
    }
}

