/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.util;

import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gearman.util.ByteUtils;
import org.gearman.util.IORuntimeException;

public final class IOUtil {
    private IOUtil() {
    }

    public static void readFully(InputStream in, byte[] buffer) {
        int c = IOUtil.read(in, buffer);
        if (c != buffer.length) {
            String msg = c + " != " + buffer.length + ": " + ByteUtils.toHex(buffer);
            throw new IORuntimeException(new EOFException(msg));
        }
    }

    public static void flush(Flushable baos) {
        try {
            baos.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static int read(InputStream in, byte[] buffer) {
        try {
            return in.read(buffer);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void write(OutputStream os, byte[] bytes) {
        try {
            os.write(bytes);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

