/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.util;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gearman.util.ByteUtils;
import org.gearman.util.IOUtil;

public class ByteArrayBuffer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] buf;
    private int copyBufferSize;

    public ByteArrayBuffer() {
        this(ByteUtils.EMPTY);
    }

    public ByteArrayBuffer(byte[] bytes) {
        this(bytes, 4096);
    }

    public ByteArrayBuffer(byte[] bytes, int copyBufferSize) {
        byte[] srcBytes = bytes == null ? ByteUtils.EMPTY : bytes;
        this.copyBufferSize = copyBufferSize;
        this.buf = new byte[srcBytes.length];
        System.arraycopy(srcBytes, 0, this.buf, 0, srcBytes.length);
    }

    public byte[] getBytes() {
        byte[] retBytes = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, retBytes, 0, this.buf.length);
        return retBytes;
    }

    public ByteArrayBuffer append(byte[] bytes) {
        return this.append(bytes, 0, bytes.length);
    }

    public ByteArrayBuffer append(byte b) {
        return this.append(new byte[]{b});
    }

    public ByteArrayBuffer append(byte[] bytes, int startPosition, int len) {
        byte[] old = this.buf;
        this.buf = new byte[old.length + len];
        System.arraycopy(old, 0, this.buf, 0, old.length);
        System.arraycopy(bytes, startPosition, this.buf, old.length, len);
        return this;
    }

    public ByteArrayBuffer append(InputStream is) {
        int len;
        int EOF = -1;
        byte[] inputBuf = new byte[this.copyBufferSize];
        while ((len = IOUtil.read(is, inputBuf)) != -1) {
            this.append(inputBuf, 0, len);
        }
        return this;
    }

    public int length() {
        return this.buf.length;
    }

    public byte[] subArray(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.buf.length || beginIndex > endIndex) {
            String msg = "[" + beginIndex + "," + endIndex + "]" + " (" + 0 + ", " + this.buf.length + ")";
            throw new IndexOutOfBoundsException(msg);
        }
        byte[] subArray = new byte[endIndex - beginIndex];
        System.arraycopy(this.buf, beginIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public int indexOf(byte b) {
        return this.indexOf(b, 0);
    }

    public int indexOf(byte b, int fromIndex) {
        for (int i = fromIndex; i < this.buf.length; ++i) {
            if (this.buf[i] != b) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte b) {
        return this.lastIndexOf(b, this.buf.length - 1);
    }

    public int lastIndexOf(byte b, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (this.buf[i] != b) continue;
            return i;
        }
        return -1;
    }

    public String toHex() {
        return ByteUtils.toHex(this.buf);
    }

    public String toString() {
        return ByteUtils.fromAsciiBytes(this.buf);
    }

    public List<byte[]> split(byte[] pattern) {
        return this.split(pattern, Integer.MAX_VALUE);
    }

    public List<byte[]> split(byte[] pattern, int limit) {
        ArrayList<byte[]> parts = new ArrayList<byte[]>();
        int begin = 0;
        int end = 0;
        for (int i = 0; i < this.buf.length && parts.size() < limit; ++i) {
            boolean found = true;
            for (int j = 0; j < pattern.length; ++j) {
                if (i + j >= this.buf.length) {
                    found = false;
                    continue;
                }
                if (this.buf[i + j] == pattern[j]) continue;
                found = false;
            }
            if (!found) continue;
            parts.add(this.subArray(begin, i));
            begin = i += pattern.length;
            end = i;
        }
        if (end < this.buf.length) {
            parts.add(this.subArray(end, this.buf.length));
        }
        return parts;
    }
}

