/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.example;

import org.gearman.client.GearmanClient;
import org.gearman.client.GearmanClientImpl;
import org.gearman.client.GearmanJob;
import org.gearman.client.GearmanJobImpl;
import org.gearman.client.GearmanJobResult;
import org.gearman.common.GearmanJobServerConnection;
import org.gearman.common.GearmanNIOJobServerConnection;
import org.gearman.example.ReverseFunction;
import org.gearman.util.ByteUtils;

public class ReverseClient {
    private GearmanClient client = new GearmanClientImpl();

    public ReverseClient(GearmanJobServerConnection conn) {
        this.client.addJobServer(conn);
    }

    public ReverseClient(String host, int port) {
        this(new GearmanNIOJobServerConnection(host, port));
    }

    public String reverse(String input) {
        String function = ReverseFunction.class.getCanonicalName();
        String uniqueId = null;
        byte[] data = ByteUtils.toUTF8Bytes(input);
        GearmanJobResult res = null;
        GearmanJob job = GearmanJobImpl.createJob(function, data, uniqueId);
        String value = "";
        this.client.submit(job);
        try {
            res = (GearmanJobResult)job.get();
            value = ByteUtils.fromUTF8Bytes(res.getResults());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public void shutdown() throws IllegalStateException {
        if (this.client == null) {
            throw new IllegalStateException("No client to shutdown");
        }
        this.client.shutdown();
    }

    public static void main(String[] args) {
        if (args.length == 0 || args.length > 3) {
            ReverseClient.usage();
            return;
        }
        String host = "127.0.0.1";
        int port = 4730;
        String payload = args[args.length - 1];
        for (String arg : args) {
            if (arg.startsWith("-h")) {
                host = arg.substring(2);
                continue;
            }
            if (!arg.startsWith("-p")) continue;
            port = Integer.parseInt(arg.substring(2));
        }
        ReverseClient rc = new ReverseClient(host, port);
        System.out.println(rc.reverse(payload));
        rc.shutdown();
    }

    public static void usage() {
        String[] usage;
        for (String line : usage = new String[]{"usage: org.gearman.example.ReverseClient [-h<host>] [-p<port>] <string>", "\t-h<host> - job server host", "\t-p<port> - job server port", "\n\tExample: java org.gearman.example.ReverseClient Foo", "\tExample: java org.gearman.example.ReverseClient -h127.0.0.1 -p4730 Bar"}) {
            System.err.println(line);
        }
    }
}

