/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.example;

import java.io.IOException;
import org.gearman.client.GearmanClientImpl;
import org.gearman.common.GearmanNIOJobServerConnection;
import org.gearman.util.ByteUtils;

public class EchoClient {
    private final GearmanClientImpl client;

    public EchoClient(String host, int port) throws IOException {
        GearmanNIOJobServerConnection connection = new GearmanNIOJobServerConnection(host, port);
        this.client = new GearmanClientImpl();
        this.client.addJobServer(connection);
    }

    public String echo(String input) throws IOException {
        byte[] data = ByteUtils.toUTF8Bytes(input);
        byte[] respBytes = this.client.echo(data);
        return ByteUtils.fromUTF8Bytes(respBytes);
    }

    public void shutdown() throws IllegalStateException {
        if (this.client == null) {
            throw new IllegalStateException("No client to shutdown");
        }
        this.client.shutdown();
    }

    public static void main(String[] args) {
        if (args.length == 0 || args.length > 3) {
            EchoClient.usage();
            return;
        }
        String host = "127.0.0.1";
        int port = 4730;
        String payload = args[args.length - 1];
        for (String arg : args) {
            if (arg.startsWith("-h")) {
                host = arg.substring(2);
                continue;
            }
            if (!arg.startsWith("-p")) continue;
            port = Integer.parseInt(arg.substring(2));
        }
        try {
            EchoClient ec = new EchoClient(host, port);
            System.out.println(ec.echo(payload));
            ec.shutdown();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void usage() {
        String[] usage;
        for (String line : usage = new String[]{"usage: gearmanij.example.EchoClient [-h<host>] [-p<port>] <string>", "\t-h<host> - job server host", "\t-p<port> - job server port", "\n\tExample: java gearmanij.example.EchoClient Foo", "\tExample: java gearmanij.example.EchoClient -h127.0.0.1 -p4730 Bar"}) {
            System.err.println(line);
        }
    }
}

