/*
 * Decompiled with CFR 0.152.
 */
package org.gearman.example;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.gearman.client.GearmanJobResult;
import org.gearman.client.GearmanJobResultImpl;
import org.gearman.util.ByteArrayBuffer;
import org.gearman.util.ByteUtils;
import org.gearman.worker.AbstractGearmanFunction;

public class DigestFunction
extends AbstractGearmanFunction {
    @Override
    public GearmanJobResult executeFunction() {
        ByteArrayBuffer bab = new ByteArrayBuffer((byte[])this.data);
        List<byte[]> params = bab.split(new byte[]{0});
        GearmanJobResultImpl jr = null;
        if (params.size() != 2) {
            String msg = "Data to digest should be preceded by name of an algorithm";
            jr = new GearmanJobResultImpl(this.jobHandle, false, new byte[0], new byte[0], ByteUtils.toUTF8Bytes(msg), 0L, 0L);
            return jr;
        }
        String algorithm = ByteUtils.fromUTF8Bytes(params.get(0));
        byte[] digestData = params.get(1);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
            byte[] digest = md.digest(digestData);
            jr = new GearmanJobResultImpl(this.jobHandle, false, digest, new byte[0], new byte[0], 0L, 0L);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "Unsupported digest algorithm " + algorithm;
            jr = new GearmanJobResultImpl(this.jobHandle, false, new byte[0], new byte[0], ByteUtils.toUTF8Bytes(msg), 0L, 0L);
        }
        return jr;
    }
}

